/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;

public class ExpressionUtil {
    private static boolean isDatetimeType(int interval) {
        return interval == 1 || interval == 3 || interval == 2 || interval == 4 || interval == 5 || interval == 6 || interval == 7 || interval == 8;
    }

    private static boolean isNumber(int dataType) {
        return dataType == 4 || dataType == 3 || dataType == 2;
    }

    private static boolean isDate(int dataType) {
        return dataType == 6;
    }

    private static boolean isString(int dataType) {
        return dataType == 5;
    }

    private static boolean isValidInterval(int interval, int dataType) throws DataException {
        if (dataType == 0 || dataType == -1) {
            return true;
        }
        switch (interval) {
            case 0: {
                return true;
            }
            case 99: {
                if (ExpressionUtil.isNumber(dataType)) {
                    return true;
                }
                throw new DataException("data.engine.group.interval", new Object[]{"numeric", DataType.getName((int)dataType)});
            }
            case 100: {
                if (ExpressionUtil.isString(dataType)) {
                    return true;
                }
                throw new DataException("data.engine.group.interval", new Object[]{"string prefix", DataType.getName((int)dataType)});
            }
        }
        if (ExpressionUtil.isDate(dataType)) {
            return true;
        }
        throw new DataException("data.engine.group.interval", new Object[]{"date", DataType.getName((int)dataType)});
    }

    static String createGroupByExpression(int interval, Object intervalStart, String keyColumn, double intervalRange, int dataType) throws BirtException {
        String reStr = null;
        if (!ExpressionUtil.isValidInterval(interval, dataType)) {
            return null;
        }
        if (intervalRange == 0.0) {
            intervalRange = 1.0;
        }
        if (ExpressionUtil.isDatetimeType(interval) && intervalStart != null) {
            intervalStart = DataTypeUtil.toDate((Object)intervalStart);
        }
        switch (interval) {
            case 0: {
                return keyColumn;
            }
            case 1: {
                if (intervalStart == null) {
                    reStr = "(%keyColumn == null)?-1:Math.floor(DateTimeSpan.years(new Date(1970,0,1),%keyColumn) / %intervalRange)";
                    break;
                }
                reStr = "(%keyColumn == null)?-1:((DateTimeSpan.years(new Date(%year,%month,%day),%keyColumn)<0)?-1:Math.floor(DateTimeSpan.years(new Date(%year,%month,%day),%keyColumn) / %intervalRange))";
                break;
            }
            case 2: {
                if (intervalStart == null) {
                    reStr = "(%keyColumn == null)?-1:Math.floor(DateTimeSpan.months(new Date(1970,0,1),%keyColumn) / %intervalRange)";
                    break;
                }
                reStr = "(%keyColumn == null)?-1:((DateTimeSpan.months(new Date(%year,%month,%day),%keyColumn)<0)?-1:Math.floor(DateTimeSpan.months(new Date(%year,%month,%day),%keyColumn) / %intervalRange))";
                break;
            }
            case 3: {
                if (intervalStart == null) {
                    reStr = "(%keyColumn == null)?-1:Math.floor(Math.floor(DateTimeSpan.months(new Date(1970,0,1),%keyColumn)/3) / %intervalRange)";
                    break;
                }
                reStr = "(%keyColumn == null)?-1:((((Math.floor(DateTimeSpan.months(new Date(1970,0,1),%keyColumn)/3) - Math.floor(DateTimeSpan.months(new Date(1970,0,1),new Date(%year,%month,%day))/3)))<0)?-1:Math.floor((Math.floor(DateTimeSpan.months(new Date(1970,0,1),%keyColumn)/3) - Math.floor(DateTimeSpan.months(new Date(1970,0,1),new Date(%year,%month,%day))/3)) / %intervalRange))";
                break;
            }
            case 4: {
                if (intervalStart == null) {
                    reStr = "(%keyColumn == null)?-1:Math.floor(Math.floor(DateTimeSpan.days(new Date(1970,0,5),%keyColumn)/7) / %intervalRange)";
                    break;
                }
                reStr = "(%keyColumn == null)?-1:(((Math.floor(DateTimeSpan.days(new Date(1970,0,5),%keyColumn)/7) - Math.floor(DateTimeSpan.days(new Date(1970,0,5),new Date(%year,%month,%day))/7))<0)?-1:Math.floor((Math.floor(DateTimeSpan.days(new Date(1970,0,5),%keyColumn)/7) - Math.floor(DateTimeSpan.days(new Date(1970,0,5),new Date(%year,%month,%day))/7)) / %intervalRange))";
                break;
            }
            case 5: {
                if (intervalStart == null) {
                    reStr = "(%keyColumn == null)?-1:Math.floor(DateTimeSpan.days(new Date(1970,0,1),%keyColumn) / %intervalRange)";
                    break;
                }
                reStr = "(%keyColumn == null)?-1:(((DateTimeSpan.days(new Date(%year,%month,%day),%keyColumn))<0)?-1:Math.floor(DateTimeSpan.days(new Date(%year,%month,%day),%keyColumn) / %intervalRange))";
                break;
            }
            case 6: {
                if (intervalStart == null) {
                    reStr = "(%keyColumn == null)?-1:Math.floor(DateTimeSpan.hours(new Date(1970,0,1),%keyColumn) / %intervalRange)";
                    break;
                }
                reStr = "(%keyColumn == null)?-1:(((DateTimeSpan.hours(new Date(%year,%month,%day,%hour,%minute,%second),%keyColumn))<0)?-1:Math.floor(DateTimeSpan.hours(new Date(%year,%month,%day,%hour,%minute,%second),%keyColumn) / %intervalRange))";
                break;
            }
            case 7: {
                if (intervalStart == null) {
                    reStr = "(%keyColumn == null)?-1:Math.floor(DateTimeSpan.minutes(new Date(1970,0,1),%keyColumn) / %intervalRange)";
                    break;
                }
                reStr = "(%keyColumn == null)?-1:(((DateTimeSpan.minutes(new Date(%year,%month,%day,%hour,%minute,%second),%keyColumn))<0)?-1:Math.floor(DateTimeSpan.minutes(new Date(%year,%month,%day,%hour,%minute,%second),%keyColumn) / %intervalRange))";
                break;
            }
            case 8: {
                if (intervalStart == null) {
                    reStr = "(%keyColumn == null)?-1:Math.floor(DateTimeSpan.seconds(new Date(1970,0,1),%keyColumn) / %intervalRange)";
                    break;
                }
                reStr = "(%keyColumn == null)?-1:(((DateTimeSpan.seconds(new Date(%year,%month,%day,%hour,%minute,%second),%keyColumn))<0)?-1:Math.floor(DateTimeSpan.seconds(new Date(%year,%month,%day,%hour,%minute,%second),%keyColumn) / %intervalRange))";
                break;
            }
            case 99: {
                if (intervalStart == null) {
                    intervalStart = "0";
                }
                reStr = "(%keyColumn == null)?-1:(((%keyColumn.valueOf() - %intervalStart)<0)?-1:Math.floor((%keyColumn.valueOf() - %intervalStart ) / %intervalRange))";
                break;
            }
            case 100: {
                reStr = "(%keyColumn != null && %keyColumn != \"\" )?%keyColumn.substring(0,%intervalRange):%keyColumn ";
            }
        }
        reStr = ExpressionUtil.populateKeyExpression(intervalStart, keyColumn, intervalRange, reStr);
        return reStr;
    }

    private static String populateKeyExpression(Object intervalStart, String keyColumn, double intervalRange, String reStr) {
        reStr = reStr.replaceAll("%keyColumn", keyColumn);
        reStr = reStr.replaceAll("%intervalRange", String.valueOf(intervalRange));
        if (intervalStart instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)intervalStart);
            reStr = reStr.replaceAll("%year", String.valueOf(cal.get(1)));
            reStr = reStr.replaceAll("%month", String.valueOf(cal.get(2)));
            reStr = reStr.replaceAll("%day", String.valueOf(cal.get(5)));
            reStr = reStr.replaceAll("%hour", String.valueOf(cal.get(11)));
            reStr = reStr.replaceAll("%minute", String.valueOf(cal.get(12)));
            reStr = reStr.replaceAll("%second", String.valueOf(cal.get(13)));
        } else if (intervalStart != null) {
            reStr = reStr.replaceAll("%intervalStart", intervalStart.toString());
        }
        return reStr;
    }
}

