/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSourceFactory;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.OdaDataSetRuntime;
import org.eclipse.birt.data.engine.impl.OdaDataSourceRuntime;
import org.eclipse.birt.data.engine.impl.ParameterMetaData;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IDataSourceQuery;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IParameterMetaData;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;

public class PreparedOdaDSQuery
extends PreparedDataSourceQuery
implements IPreparedQuery {
    PreparedOdaDSQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        super(dataEngine, queryDefn, dataSetDesign, appContext);
        logger.logp(Level.FINER, PreparedOdaDSQuery.class.getName(), "PreparedExtendedDSQuery", "PreparedExtendedDSQuery starts up");
    }

    protected QueryExecutor newExecutor() {
        return new OdaDSQueryExecutor();
    }

    private static Map copyProperties(Map publicProps, Map privateProps) {
        if (publicProps.isEmpty() && privateProps.isEmpty()) {
            return null;
        }
        HashMap driverProps = new HashMap();
        if (!publicProps.isEmpty()) {
            driverProps.putAll(publicProps);
        }
        if (!privateProps.isEmpty()) {
            driverProps.putAll(privateProps);
        }
        return driverProps;
    }

    private static void addProperty(IDataSourceQuery odiDSQuery, Map props) throws DataException {
        if (props == null) {
            return;
        }
        Set entries = props.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String propName = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (propName == null || propName.length() == 0) continue;
            odiDSQuery.addProperty(propName, value);
        }
    }

    public Collection getParameterMetaData() throws DataException {
        OdaDSQueryExecutor exec = new OdaDSQueryExecutor();
        return exec.getParameterMetaData();
    }

    public class OdaDSQueryExecutor
    extends PreparedDataSourceQuery.DSQueryExecutor {
        private IPreparedDSQuery odiPreparedQuery;
        static final /* synthetic */ boolean $assertionsDisabled;

        public IPreparedDSQuery getPreparedOdiQuery() {
            return this.odiPreparedQuery;
        }

        protected IDataSource createOdiDataSource() throws DataException {
            OdaDataSourceRuntime extDS = (OdaDataSourceRuntime)this.dataSource;
            if (!$assertionsDisabled && extDS == null) {
                throw new AssertionError();
            }
            String driverName = extDS.getExtensionID();
            if (driverName == null || driverName.length() == 0) {
                throw new DataException("data.engine.DataSourceMissingExtId", extDS.getName());
            }
            Map driverProps = PreparedOdaDSQuery.copyProperties(extDS.getPublicProperties(), extDS.getPrivateProperties());
            return DataSourceFactory.getFactory().getDataSource(driverName, driverProps, this.dataSource.getDesign(), this.dataSet.getDesign());
        }

        protected IQuery createOdiQuery() throws DataException {
            OdaDataSetRuntime extDataSet = (OdaDataSetRuntime)this.dataSet;
            if (!$assertionsDisabled && extDataSet == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.odiDataSource == null) {
                throw new AssertionError();
            }
            IDataSourceQuery odiQuery = null;
            String dataSetType = extDataSet.getExtensionID();
            String dataText = extDataSet.getQueryText();
            odiQuery = this.odiDataSource.newQuery(dataSetType, dataText);
            return odiQuery;
        }

        protected void populateOdiQuery() throws DataException {
            List ccList;
            super.populateOdiQuery();
            OdaDataSetRuntime extDataSet = (OdaDataSetRuntime)this.dataSet;
            if (!$assertionsDisabled && extDataSet == null) {
                throw new AssertionError();
            }
            IDataSourceQuery odiDSQuery = (IDataSourceQuery)this.odiQuery;
            if (!$assertionsDisabled && odiDSQuery == null) {
                throw new AssertionError();
            }
            PreparedOdaDSQuery.addProperty(odiDSQuery, extDataSet.getPublicProperties());
            PreparedOdaDSQuery.addProperty(odiDSQuery, extDataSet.getPrivateProperties());
            odiDSQuery.setParameterHints(this.resolveDataSetParameters(true));
            if (extDataSet.getResultSetHints() != null) {
                List source = extDataSet.getResultSetHints();
                int count = source.size();
                ArrayList<IDataSourceQuery.ResultFieldHint> hints = new ArrayList<IDataSourceQuery.ResultFieldHint>(count);
                for (int i = 0; i < count; ++i) {
                    IColumnDefinition def = (IColumnDefinition)source.get(i);
                    IDataSourceQuery.ResultFieldHint hint = new IDataSourceQuery.ResultFieldHint(def.getColumnName());
                    hint.setPosition(def.getColumnPosition());
                    hint.setAlias(def.getAlias());
                    hint.setDataType(def.getDataType());
                    hints.add(hint);
                }
                odiDSQuery.setResultHints(hints);
            }
            if ((ccList = extDataSet.getComputedColumns()) != null) {
                for (int i = 0; i < ccList.size(); ++i) {
                    IComputedColumn cc = (IComputedColumn)ccList.get(i);
                    odiDSQuery.declareCustomField(cc.getName(), cc.getDataType());
                }
            }
            odiDSQuery.setResultProjection(PreparedOdaDSQuery.this.getReportQueryDefn().getColumnProjection());
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            this.dataSet.afterOpen();
            OdaDataSetRuntime odaDataSet = (OdaDataSetRuntime)this.dataSet;
            if (!$assertionsDisabled && odaDataSet == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.odiPreparedQuery == null) {
                throw new AssertionError();
            }
            return this.odiPreparedQuery.execute(eventHandler);
        }

        protected void prepareOdiQuery() throws DataException {
            IDataSourceQuery odiDSQuery = (IDataSourceQuery)this.odiQuery;
            if (!$assertionsDisabled && odiDSQuery == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.odiPreparedQuery != null) {
                throw new AssertionError();
            }
            this.odiPreparedQuery = odiDSQuery.prepare();
        }

        private Collection getParameterMetaData() throws DataException {
            this.dataSet = this.newDataSetRuntime();
            if (!$assertionsDisabled && this.dataSet == null) {
                throw new AssertionError();
            }
            OdaDataSetRuntime odaDataSet = (OdaDataSetRuntime)this.dataSet;
            this.dataSource = this.findDataSource();
            this.openDataSource();
            this.dataSet.beforeOpen();
            this.odiQuery = this.createOdiQuery();
            IDataSourceQuery odiDSQuery = (IDataSourceQuery)this.odiQuery;
            if (!$assertionsDisabled && odiDSQuery == null) {
                throw new AssertionError();
            }
            PreparedOdaDSQuery.addProperty(odiDSQuery, odaDataSet.getPublicProperties());
            PreparedOdaDSQuery.addProperty(odiDSQuery, odaDataSet.getPrivateProperties());
            odiDSQuery.setParameterHints(this.resolveDataSetParameters(false));
            this.prepareOdiQuery();
            if (!$assertionsDisabled && this.odiPreparedQuery == null) {
                throw new AssertionError();
            }
            Collection odiParamsInfo = this.odiPreparedQuery.getParameterMetaData();
            if (odiParamsInfo == null || odiParamsInfo.isEmpty()) {
                return null;
            }
            ArrayList<ParameterMetaData> paramMetaDataList = new ArrayList<ParameterMetaData>(odiParamsInfo.size());
            Iterator odiParamMDIter = odiParamsInfo.iterator();
            while (odiParamMDIter.hasNext()) {
                IParameterMetaData odiMetaData = (IParameterMetaData)odiParamMDIter.next();
                ParameterMetaData apiMetaData = new ParameterMetaData(odiMetaData);
                paramMetaDataList.add(apiMetaData);
            }
            return paramMetaDataList;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$impl$PreparedOdaDSQuery == null ? (class$org$eclipse$birt$data$engine$impl$PreparedOdaDSQuery = PreparedOdaDSQuery.class$("org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery")) : class$org$eclipse$birt$data$engine$impl$PreparedOdaDSQuery).desiredAssertionStatus();
        }
    }
}

