/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.IServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVSubQuery;
import org.eclipse.birt.data.engine.impl.PreparedSubquery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.JSResultSetRow;
import org.mozilla.javascript.Scriptable;

public class ServiceForQueryResults
implements IServiceForQueryResults {
    private DataEngineContext context;
    private IPreparedQueryService queryService;
    private IQueryExecutor queryExecutor;
    private PreparedDataSourceQuery reportQuery;
    private IBaseQueryDefinition queryDefn;
    private ExprManager exprManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ServiceForQueryResults(DataEngineContext context, PreparedDataSourceQuery reportQuery, IPreparedQueryService query, QueryExecutor queryExecutor, IBaseQueryDefinition queryDefn, ExprManager exprManager) {
        if (!($assertionsDisabled || reportQuery != null && queryExecutor != null)) {
            throw new AssertionError();
        }
        this.context = context;
        this.reportQuery = reportQuery;
        this.queryService = query;
        this.queryExecutor = queryExecutor;
        this.queryDefn = queryDefn;
        this.exprManager = exprManager;
    }

    public DataEngineContext getContext() {
        return this.context;
    }

    public IBaseQueryDefinition getQueryDefn() {
        return this.queryDefn;
    }

    public IPreparedQuery getPreparedQuery() {
        return this.reportQuery;
    }

    public int getGroupLevel() {
        if (this.queryService instanceof PreparedSubquery) {
            PreparedSubquery subQuery = (PreparedSubquery)this.queryService;
            return subQuery.getGroupLevel();
        }
        if (this.queryService instanceof PreparedIVSubQuery) {
            PreparedIVSubQuery subQuery = (PreparedIVSubQuery)this.queryService;
            return subQuery.getGroupLevel();
        }
        return 0;
    }

    public DataSetRuntime[] getDataSetRuntimes(int count) {
        if (!$assertionsDisabled && count < 0) {
            throw new AssertionError();
        }
        DataSetRuntime[] dsRuns = new DataSetRuntime[count];
        if (count > 1) {
            DataSetRuntime[] innerDsRuns = null;
            IQueryExecutor executor = this.queryExecutor;
            innerDsRuns = executor.getNestedDataSets(count - 1);
            for (int i = 0; i < count - 1; ++i) {
                dsRuns[i] = innerDsRuns[i];
            }
        }
        dsRuns[count - 1] = this.queryExecutor.getDataSet();
        return dsRuns;
    }

    public DataSetRuntime getDataSetRuntime() {
        return this.queryExecutor.getDataSet();
    }

    public IResultMetaData getResultMetaData() throws DataException {
        return this.queryExecutor.getResultMetaData();
    }

    public IResultIterator executeQuery() throws DataException {
        this.queryExecutor.execute(new EventHandler());
        return this.queryExecutor.getOdiResultSet();
    }

    public IQueryResults execSubquery(IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
        return this.queryService.execSubquery(iterator, subQueryName, subScope);
    }

    public void close() {
        if (this.queryExecutor != null) {
            this.queryExecutor.close();
            this.queryExecutor = null;
        }
    }

    public IBaseExpression getBaseExpression(String exprName) {
        return this.exprManager.getExpr(exprName);
    }

    public ExprManager getExprManager() {
        return this.exprManager;
    }

    public boolean needAutoBinding() {
        if (this.queryDefn instanceof IQueryDefinition) {
            return ((IQueryDefinition)this.queryDefn).needAutoBinding();
        }
        return false;
    }

    public void addAutoBindingExpr(String exprName, IBaseExpression baseExpr) {
        this.exprManager.addAutoBindingExpr(exprName, baseExpr);
    }

    public IScriptExpression getAutoBindingExpr(String exprName) {
        return this.exprManager.getAutoBindingExpr(exprName);
    }

    public void validateQueryColumBinding() throws DataException {
        this.exprManager.validateColumnBinding();
    }

    public List getAllBindingExprs() {
        return this.exprManager.getBindingExprs();
    }

    public Map getAllAutoBindingExprs() {
        return this.exprManager.getAutoBindingExprMap();
    }

    static {
        $assertionsDisabled = !ServiceForQueryResults.class.desiredAssertionStatus();
    }

    private class EventHandler
    implements IEventHandler {
        private JSResultSetRow jsResultSetRow;
        private IExecutorHelper helper;

        private EventHandler() {
        }

        public void handleEndOfDataSetProcess(IResultIterator resultIterator) {
            this.jsResultSetRow = new JSResultSetRow(resultIterator, ServiceForQueryResults.this.exprManager, this.helper.getScope(), this.helper);
            ServiceForQueryResults.this.getDataSetRuntime().setJSResultSetRow(this.jsResultSetRow);
        }

        public Object getValue(IResultObject rsObject, int index, String name) throws DataException {
            if (this.jsResultSetRow == null) {
                return rsObject.getFieldValue(index);
            }
            return this.jsResultSetRow.getValue(rsObject, index, name);
        }

        public boolean isRowID(int index, String name) {
            IBaseExpression baseExpr = ServiceForQueryResults.this.exprManager.getExpr(name);
            if (baseExpr instanceof IScriptExpression) {
                String exprText = ((IScriptExpression)baseExpr).getText();
                if (exprText == null) {
                    return false;
                }
                return exprText.trim().equalsIgnoreCase("dataSetRow[0]") || exprText.trim().equalsIgnoreCase("dataSetRow._rowPosition");
            }
            return false;
        }

        public IBaseExpression getBaseExpr(String name) {
            if (name == null) {
                return null;
            }
            return ServiceForQueryResults.this.exprManager.getExpr(name);
        }

        public IExecutorHelper getExecutorHelper() {
            return this.helper;
        }

        public void setExecutorHelper(IExecutorHelper helper) {
            this.helper = helper;
        }
    }
}

