/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.jointdataset;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.impl.jointdataset.IJoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.IMatchResultObjectSeeker;
import org.eclipse.birt.data.engine.impl.jointdataset.JointResultMetadata;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class BaseJointDataSetPopulator
implements IDataSetPopulator {
    private JointResultMetadata meta;
    private IResultIterator primaryIterator;
    private IResultIterator secondaryIterator;
    private int joinType;
    private int lastPopulatePrimaryIndex;
    private IMatchResultObjectSeeker seeker;

    public BaseJointDataSetPopulator(IResultIterator left, IResultIterator right, JointResultMetadata meta, IJoinConditionMatcher jcm, int joinType, IMatchResultObjectSeeker seeker) throws DataException {
        this.meta = meta;
        this.joinType = joinType;
        this.lastPopulatePrimaryIndex = -1;
        if (this.joinType != 2) {
            this.primaryIterator = left;
            this.secondaryIterator = right;
        } else {
            this.primaryIterator = right;
            this.secondaryIterator = left;
        }
        this.seeker = seeker;
        this.seeker.setResultIterator(this.secondaryIterator);
    }

    public IResultObject next() throws DataException {
        IResultObject primary;
        while ((primary = this.primaryIterator.getCurrentResult()) != null) {
            IResultObject secondary = this.seeker.getNextMatchedResultObject(this.primaryIterator.getCurrentResultIndex());
            if (secondary == null) {
                this.secondaryIterator.first(0);
                if (this.joinType != 0 && this.primaryIterator.getCurrentResultIndex() != this.lastPopulatePrimaryIndex) {
                    IResultObject result = this.createResultObject(primary, secondary);
                    this.primaryIterator.next();
                    return result;
                }
            } else {
                this.lastPopulatePrimaryIndex = this.primaryIterator.getCurrentResultIndex();
                return this.createResultObject(primary, secondary);
            }
            if (this.primaryIterator.next()) continue;
        }
        return null;
    }

    private IResultObject createResultObject(IResultObject primary, IResultObject secondary) throws DataException {
        Object[] fields = new Object[this.meta.getResultClass().getFieldCount()];
        for (int i = 1; i <= fields.length; ++i) {
            IResultObject ri = null;
            if (this.meta.getColumnSource(i) == 1) {
                ri = this.joinType != 2 ? primary : secondary;
            } else if (this.meta.getColumnSource(i) == 2) {
                ri = this.joinType != 2 ? secondary : primary;
            }
            fields[i - 1] = ri == null ? null : ri.getFieldValue(this.meta.getSourceIndex(i));
        }
        return new ResultObject(this.meta.getResultClass(), fields);
    }
}

