/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSetMetaData;

class ProjectedColumns {
    private ArrayList m_columns;
    private int[] m_projectedIndices;
    private int m_baseColumnMetadataCount;
    private ArrayList m_customColumns;
    private ArrayList m_columnHints;
    private String[] m_projectedColumns;
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    ProjectedColumns(ResultSetMetaData runtimeMetaData) throws DataException {
        String methodName = "ProjectedColumns";
        sm_logger.entering(sm_className, methodName, runtimeMetaData);
        if (!$assertionsDisabled && runtimeMetaData == null) {
            throw new AssertionError();
        }
        this.m_columns = new ArrayList();
        this.m_baseColumnMetadataCount = runtimeMetaData.getColumnCount();
        for (int i = 1; i <= this.m_baseColumnMetadataCount; ++i) {
            String name = runtimeMetaData.getColumnName(i);
            String label = runtimeMetaData.getColumnLabel(i);
            Class driverDataType = runtimeMetaData.getColumnTypeAsJavaClass(i);
            String nativeTypeName = runtimeMetaData.getColumnNativeTypeName(i);
            ResultFieldMetadata column = new ResultFieldMetadata(i, name, label, driverDataType, nativeTypeName, false);
            column.setDriverProvidedDataType(driverDataType);
            this.m_columns.add(column);
        }
        sm_logger.exiting(sm_className, methodName, this);
    }

    void addHint(ColumnHint columnHint) throws DataException {
        String methodName = "addHint";
        sm_logger.entering(sm_className, methodName, columnHint);
        if (!$assertionsDisabled && columnHint == null) {
            throw new AssertionError();
        }
        int columnPosition = columnHint.getPosition();
        if (columnPosition > 0 && columnPosition <= this.m_columns.size()) {
            String newColumnName;
            int driverIndex = columnPosition - 1;
            ResultFieldMetadata column = (ResultFieldMetadata)this.m_columns.get(driverIndex);
            String columnHintAlias = columnHint.getAlias();
            if (columnHintAlias != null) {
                this.validateNewNameOrAlias(columnHintAlias, driverIndex);
            }
            if ((newColumnName = columnHint.getName()) != null && newColumnName.length() > 0) {
                this.validateNewNameOrAlias(newColumnName, driverIndex);
                column.setName(newColumnName);
            }
            this.updateDataTypeAndAlias(column, columnHintAlias, columnHint.getDataType());
        } else {
            String columnHintName = columnHint.getName();
            int n = this.m_columns.size();
            for (int i = 0; i < n; ++i) {
                ResultFieldMetadata column = (ResultFieldMetadata)this.m_columns.get(i);
                if (!column.getName().equals(columnHintName)) continue;
                String columnHintAlias = columnHint.getAlias();
                if (columnHintAlias != null) {
                    this.validateNewNameOrAlias(columnHintAlias, i);
                }
                this.updateDataTypeAndAlias(column, columnHintAlias, columnHint.getDataType());
            }
        }
        this.doGetColumnHints().add(columnHint);
        sm_logger.exiting(sm_className, methodName);
    }

    private void updateDataTypeAndAlias(ResultFieldMetadata column, String columnHintAlias, Class columnHintType) {
        String methodName = "updateDataTypeAndAlias";
        if (column.getDriverProvidedDataType() == null && columnHintType != null) {
            column.setDataType(columnHintType);
        }
        column.setAlias(columnHintAlias);
        if (sm_logger.isLoggable(Level.FINER)) {
            sm_logger.logp(Level.FINER, sm_className, methodName, "Updated columns to data type: {0} , alias: {1}.", new Object[]{columnHintType, columnHintAlias});
        }
    }

    private ArrayList doGetColumnHints() {
        if (this.m_columnHints == null) {
            this.m_columnHints = new ArrayList();
        }
        return this.m_columnHints;
    }

    void addCustomColumn(String columnName, Class columnType) throws DataException {
        String methodName = "addCustomColumn";
        sm_logger.entering(sm_className, methodName, columnName);
        if (!($assertionsDisabled || columnName != null && columnName.length() > 0)) {
            throw new AssertionError();
        }
        this.validateNewNameOrAlias(columnName, -1);
        ResultFieldMetadata column = new ResultFieldMetadata(-1, columnName, columnName, columnType, null, true);
        this.m_columns.add(column);
        this.doGetCustomColumns().add(new PreparedStatement.CustomColumn(columnName, columnType));
        sm_logger.exiting(sm_className, methodName, column);
    }

    private ArrayList doGetCustomColumns() {
        if (this.m_customColumns == null) {
            this.m_customColumns = new ArrayList();
        }
        return this.m_customColumns;
    }

    void setProjectedNames(String[] projectedColumns) throws DataException {
        String methodName = "setProjectedNames";
        sm_logger.entering(sm_className, methodName, projectedColumns);
        if (projectedColumns == null) {
            this.projectAllBaseColumns();
        } else {
            this.projectSelectedBaseColumns(projectedColumns);
        }
        this.m_projectedColumns = projectedColumns;
        sm_logger.exiting(sm_className, methodName);
    }

    List getColumnsMetadata() {
        int i;
        String methodName = "getColumnsMetadata";
        sm_logger.entering(sm_className, methodName);
        if (this.m_projectedIndices == null) {
            this.projectAllBaseColumns();
        }
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        int n = this.m_projectedIndices.length;
        for (i = 0; i < n; ++i) {
            int colIndex = this.m_projectedIndices[i];
            ResultFieldMetadata column = (ResultFieldMetadata)this.m_columns.get(colIndex);
            projectedColumns.add(column);
        }
        n = this.m_columns.size();
        for (i = this.m_baseColumnMetadataCount; i < n; ++i) {
            ResultFieldMetadata column = (ResultFieldMetadata)this.m_columns.get(i);
            projectedColumns.add(column);
        }
        sm_logger.exiting(sm_className, methodName, projectedColumns);
        return projectedColumns;
    }

    private void projectSelectedBaseColumns(String[] projectedColumns) throws DataException {
        String methodName = "projectSelectedBaseColumns";
        ArrayList<Integer> projectedIndices = new ArrayList<Integer>();
        for (int i = 0; i < projectedColumns.length; ++i) {
            String projectedName = projectedColumns[i];
            if (!$assertionsDisabled && projectedName == null && projectedName.length() != 0) {
                throw new AssertionError();
            }
            int colIndex = this.findColumnIndex(projectedName);
            if (colIndex >= 0 && colIndex < this.m_baseColumnMetadataCount) {
                projectedIndices.add(new Integer(colIndex));
                continue;
            }
            if (colIndex >= this.m_baseColumnMetadataCount) continue;
            projectedIndices = null;
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "No match found for project column {0} ", projectedName);
            throw new DataException("odaconsumer.UnrecognizedProjectedColumnName", new Object[]{projectedName});
        }
        int size = projectedIndices.size();
        this.m_projectedIndices = new int[size];
        for (int i = 0; i < size; ++i) {
            this.m_projectedIndices[i] = (Integer)projectedIndices.get(i);
        }
    }

    private int findColumnIndex(String projectedName) {
        String methodName = "findColumnIndex";
        int foundIndex = -1;
        int n = this.m_columns.size();
        for (int colIndex = 0; colIndex < n; ++colIndex) {
            ResultFieldMetadata column = (ResultFieldMetadata)this.m_columns.get(colIndex);
            if (!projectedName.equals(column.getName()) && !projectedName.equals(column.getAlias())) continue;
            foundIndex = colIndex;
            break;
        }
        if (sm_logger.isLoggable(Level.FINEST)) {
            sm_logger.logp(Level.FINEST, sm_className, methodName, "Found column {0} at index {1}.", new Object[]{projectedName, new Integer(foundIndex)});
        }
        return foundIndex;
    }

    private void projectAllBaseColumns() {
        String methodName = "projectAllBaseColumns";
        this.m_projectedIndices = new int[this.m_baseColumnMetadataCount];
        for (int i = 0; i < this.m_baseColumnMetadataCount; ++i) {
            this.m_projectedIndices[i] = i;
        }
        if (sm_logger.isLoggable(Level.FINEST)) {
            sm_logger.logp(Level.FINEST, sm_className, methodName, "Projected all columns {0} .", (Object)this.m_projectedIndices);
        }
    }

    private void validateNewNameOrAlias(String newColumnNameOrAlias, int driverIndex) throws DataException {
        String methodName = "validateNewNameOrAlias";
        if (!($assertionsDisabled || newColumnNameOrAlias != null && newColumnNameOrAlias.length() > 0)) {
            throw new AssertionError();
        }
        int n = this.m_columns.size();
        for (int i = 0; i < n; ++i) {
            ResultFieldMetadata column;
            if (i == driverIndex || ((column = (ResultFieldMetadata)this.m_columns.get(i)).getName() == null || !column.getName().equals(newColumnNameOrAlias)) && (column.getAlias() == null || !column.getAlias().equals(newColumnNameOrAlias))) continue;
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "column name or alias {0} is aready used by column {1}", new Object[]{newColumnNameOrAlias, column});
            throw new DataException("odaconsumer.ColumnNameOrAliasAlreadyUsed", new Object[]{newColumnNameOrAlias, new Integer(i + 1)});
        }
    }

    ArrayList getColumnHints() {
        return this.m_columnHints;
    }

    ArrayList getCustomColumns() {
        return this.m_customColumns;
    }

    String[] getProjections() {
        return this.m_projectedColumns;
    }

    static {
        $assertionsDisabled = !ProjectedColumns.class.desiredAssertionStatus();
        sm_className = ProjectedColumns.class.getName();
        sm_loggerName = ConnectionManager.sm_packageName;
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }
}

