/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet {
    private IResultSet m_resultSet;
    private IResultClass m_resultClass;
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$oda$IBlob;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$oda$IClob;

    ResultSet(IResultSet resultSet, IResultClass resultClass) {
        String methodName = "ResultSet";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, "ResultSet", new Object[]{resultSet, resultClass});
        }
        if (!($assertionsDisabled || resultSet != null && resultClass != null)) {
            throw new AssertionError();
        }
        this.m_resultSet = resultSet;
        this.m_resultClass = resultClass;
        sm_logger.exiting(sm_className, "ResultSet", this);
    }

    public IResultClass getMetaData() throws DataException {
        return this.m_resultClass;
    }

    public void setMaxRows(int max) throws DataException {
        String methodName = "setMaxRows";
        try {
            this.m_resultSet.setMaxRows(max);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "setMaxRows", "Cannot set max rows.", ex);
            throw new DataException("odaconsumer.CannotSetMaxRows", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "setMaxRows", "Cannot set max rows.", ex);
        }
    }

    public IResultObject fetch() throws DataException {
        if (this.m_resultSet == null) {
            return null;
        }
        String methodName = "fetch";
        try {
            if (!this.m_resultSet.next()) {
                return null;
            }
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "fetch", "Cannot fetch next row.", ex);
            throw new DataException("odaconsumer.CannotFetchNextRow", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "fetch", "Cannot fetch next row.", ex);
            throw new DataException("odaconsumer.CannotFetchNextRow", ex);
        }
        int columnCount = this.m_resultClass.getFieldCount();
        int[] driverPositions = ((ResultClass)this.m_resultClass).getFieldDriverPositions();
        if (!$assertionsDisabled && columnCount != driverPositions.length) {
            throw new AssertionError();
        }
        Object[] fields = new Object[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            if (this.m_resultClass.isCustomField(i)) continue;
            Class dataType = this.m_resultClass.getFieldValueClass(i);
            int driverPosition = driverPositions[i - 1];
            Object colValue = null;
            if (dataType == (class$java$lang$Integer == null ? ResultSet.class$("java.lang.Integer") : class$java$lang$Integer)) {
                int j = this.getInt(driverPosition);
                if (!this.wasNull()) {
                    colValue = new Integer(j);
                }
            } else if (dataType == (class$java$lang$Double == null ? ResultSet.class$("java.lang.Double") : class$java$lang$Double)) {
                double d = this.getDouble(driverPosition);
                if (!this.wasNull()) {
                    colValue = new Double(d);
                }
            } else if (dataType == (class$java$lang$String == null ? ResultSet.class$("java.lang.String") : class$java$lang$String)) {
                colValue = this.getString(driverPosition);
            } else if (dataType == (class$java$math$BigDecimal == null ? ResultSet.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                colValue = this.getBigDecimal(driverPosition);
            } else if (dataType == (class$java$util$Date == null ? ResultSet.class$("java.util.Date") : class$java$util$Date)) {
                colValue = this.getDate(driverPosition);
            } else if (dataType == (class$java$sql$Time == null ? ResultSet.class$("java.sql.Time") : class$java$sql$Time)) {
                colValue = this.getTime(driverPosition);
            } else if (dataType == (class$java$sql$Timestamp == null ? ResultSet.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                colValue = this.getTimestamp(driverPosition);
            } else if (dataType == (class$org$eclipse$datatools$connectivity$oda$IBlob == null ? ResultSet.class$("org.eclipse.datatools.connectivity.oda.IBlob") : class$org$eclipse$datatools$connectivity$oda$IBlob)) {
                colValue = this.getBlob(driverPosition);
            } else if (dataType == (class$org$eclipse$datatools$connectivity$oda$IClob == null ? ResultSet.class$("org.eclipse.datatools.connectivity.oda.IClob") : class$org$eclipse$datatools$connectivity$oda$IClob)) {
                colValue = this.getClob(driverPosition);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            if (this.wasNull()) {
                colValue = null;
            }
            fields[i - 1] = colValue;
        }
        ResultObject ret = new ResultObject(this.m_resultClass, fields);
        sm_logger.logp(Level.FINEST, sm_className, "fetch", "Fetched next row: {0} .", ret);
        return ret;
    }

    private int getInt(int driverPosition) throws DataException {
        String methodName = "getInt";
        try {
            return this.m_resultSet.getInt(driverPosition);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getInt", "Cannot get integer value.", ex);
            throw new DataException("odaconsumer.CannotGetIntFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getInt", "Cannot get integer value.", ex);
            throw new DataException("odaconsumer.CannotGetIntFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
    }

    private double getDouble(int driverPosition) throws DataException {
        String methodName = "getDouble";
        try {
            return this.m_resultSet.getDouble(driverPosition);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getDouble", "Cannot get double value.", ex);
            throw new DataException("odaconsumer.CannotGetDoubleFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getDouble", "Cannot get double value.", ex);
            throw new DataException("odaconsumer.CannotGetDoubleFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
    }

    private String getString(int driverPosition) throws DataException {
        String methodName = "getString";
        try {
            return this.m_resultSet.getString(driverPosition);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getString", "Cannot get string value.", ex);
            throw new DataException("odaconsumer.CannotGetStringFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getString", "Cannot get string value.", ex);
            throw new DataException("odaconsumer.CannotGetStringFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
    }

    private BigDecimal getBigDecimal(int driverPosition) throws DataException {
        String methodName = "getBigDecimal";
        try {
            return this.m_resultSet.getBigDecimal(driverPosition);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getBigDecimal", "Cannot get big decimal value.", ex);
            throw new DataException("odaconsumer.CannotGetBigDecimalFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getBigDecimal", "Cannot get big decimal value.", ex);
            throw new DataException("odaconsumer.CannotGetBigDecimalFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
    }

    private Date getDate(int driverPosition) throws DataException {
        String methodName = "getDate";
        try {
            return this.m_resultSet.getDate(driverPosition);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getDate", "Cannot get date value.", ex);
            throw new DataException("odaconsumer.CannotGetDateFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getDate", "Cannot get date value.", ex);
            throw new DataException("odaconsumer.CannotGetDateFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
    }

    private Time getTime(int driverPosition) throws DataException {
        String methodName = "getTime";
        try {
            return this.m_resultSet.getTime(driverPosition);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getTime", "Cannot get time value.", ex);
            throw new DataException("odaconsumer.CannotGetTimeFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getTime", "Cannot get time value.", ex);
            throw new DataException("odaconsumer.CannotGetTimeFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
    }

    private Timestamp getTimestamp(int driverPosition) throws DataException {
        String methodName = "getTimestamp";
        try {
            return this.m_resultSet.getTimestamp(driverPosition);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getTimestamp", "Cannot get timestamp value.", ex);
            throw new DataException("odaconsumer.CannotGetTimestampFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getTimestamp", "Cannot get timestamp value.", ex);
            throw new DataException("odaconsumer.CannotGetTimestampFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
    }

    private IBlob getBlob(int driverPosition) throws DataException {
        String methodName = "getBlob";
        try {
            return this.m_resultSet.getBlob(driverPosition);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getBlob", "Cannot get BLOB value.", ex);
            throw new DataException("odaconsumer.CannotGetBlobFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getBlob", "Cannot get BLOB value.", ex);
            throw new DataException("odaconsumer.CannotGetBlobFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
    }

    private IClob getClob(int driverPosition) throws DataException {
        String methodName = "getClob";
        try {
            return this.m_resultSet.getClob(driverPosition);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getClob", "Cannot get CLOB value.", ex);
            throw new DataException("odaconsumer.CannotGetClobFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getClob", "Cannot get CLOB value.", ex);
            throw new DataException("odaconsumer.CannotGetClobFromColumn", (Throwable)ex, new Object[]{new Integer(driverPosition)});
        }
    }

    private boolean wasNull() throws DataException {
        String methodName = "wasNull";
        try {
            return this.m_resultSet.wasNull();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "wasNull", "Cannot check wasNull.", ex);
            throw new DataException("odaconsumer.CannotDetermineWasNull", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "wasNull", "Cannot check wasNull. Default to false.", ex);
            return false;
        }
    }

    public int getRowPosition() throws DataException {
        String methodName = "getRowPosition";
        try {
            return this.m_resultSet.getRow();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getRowPosition", "Cannot get row position.", ex);
            throw new DataException("odaconsumer.CannotGetRowPosition", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "getRowPosition", "Cannot get row position.  Default to 0.", ex);
            return 0;
        }
    }

    public void close() throws DataException {
        String methodName = "close";
        sm_logger.entering(sm_className, "close");
        try {
            this.m_resultSet.close();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "close", "Cannot close result set.", ex);
            throw new DataException("odaconsumer.CannotCloseResultSet", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "close", "Cannot close result set.", ex);
        }
        sm_logger.exiting(sm_className, "close");
    }

    static {
        $assertionsDisabled = !ResultSet.class.desiredAssertionStatus();
        sm_className = ResultSet.class.getName();
        sm_loggerName = ConnectionManager.sm_packageName;
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }
}

