/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;

public class FilterUtil {
    private FilterUtil() {
    }

    public static List sortFilters(List filters) {
        if (filters == null) {
            return null;
        }
        int size = filters.size();
        Object[] filterArray = new Object[size];
        for (int i = 0; i < size; ++i) {
            filterArray[i] = filters.get(i);
        }
        Arrays.sort(filterArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof FilterDefinition && FilterUtil.isTopOrBottomFilter((FilterDefinition)o1)) {
                    return -1;
                }
                if (o2 instanceof FilterDefinition && FilterUtil.isTopOrBottomFilter((FilterDefinition)o2)) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<Object> sortedFilters = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            sortedFilters.add(filterArray[i]);
        }
        return sortedFilters;
    }

    private static boolean isTopOrBottomFilter(FilterDefinition fd) {
        ConditionalExpression ce;
        IBaseExpression be = fd.getExpression();
        return be instanceof ConditionalExpression && ((ce = (ConditionalExpression)be).getOperator() == 14 || ce.getOperator() == 16 || ce.getOperator() == 15 || ce.getOperator() == 17);
    }
}

