/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IDataAdapterFactory;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;
import org.eclipse.birt.report.model.api.DataSetHandle;

public abstract class DataRequestSession {
    public static DataRequestSession newSession(DataSessionContext context) throws BirtException {
        return DataRequestSession.newSession(null, context);
    }

    public static DataRequestSession newSession(PlatformConfig platformConfig, DataSessionContext context) throws BirtException {
        Platform.startup((PlatformConfig)platformConfig);
        Object factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.data.adapter.DataAdapterFactory");
        if (factory instanceof IDataAdapterFactory) {
            return ((IDataAdapterFactory)factory).createSession(context);
        }
        throw new AdapterException("load.factory.error");
    }

    public abstract IModelAdapter getModelAdaptor();

    public abstract void defineDataSource(IBaseDataSourceDesign var1) throws BirtException;

    public abstract void defineDataSet(IBaseDataSetDesign var1) throws BirtException;

    public abstract IResultMetaData getDataSetMetaData(String var1, boolean var2) throws BirtException;

    public abstract IResultMetaData getDataSetMetaData(DataSetHandle var1, boolean var2) throws BirtException;

    public abstract IResultMetaData refreshMetaData(DataSetHandle var1) throws BirtException;

    public abstract Collection getColumnValueSet(DataSetHandle var1, Iterator var2, Iterator var3, String var4) throws BirtException;

    public abstract Collection getColumnValueSet(DataSetHandle var1, Iterator var2, Iterator var3, String var4, IRequestInfo var5) throws BirtException;

    public abstract IQueryResults executeQuery(QueryDefinition var1, Iterator var2, Iterator var3, Iterator var4) throws BirtException;

    public abstract IQueryResults getQueryResults(String var1) throws BirtException;

    public abstract IPreparedQuery prepare(IQueryDefinition var1, Map var2) throws BirtException;

    public abstract void closeDataSource(String var1) throws BirtException;

    public abstract void clearCache(IBaseDataSourceDesign var1, IBaseDataSetDesign var2) throws BirtException;

    public abstract void shutdown();
}

