/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api;

import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.internal.script.DataAdapterTopLevelScope;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class DataSessionContext {
    public static final int MODE_GENERATION = 1;
    public static final int MODE_PRESENTATION = 2;
    public static final int MODE_DIRECT_PRESENTATION = 3;
    public static final int CACHE_USE_DEFAULT = 1;
    public static final int CACHE_USE_DISABLE = 2;
    public static final int CACHE_USE_ALWAYS = 3;
    private boolean hasExternalScope = false;
    private int mode = 3;
    private Scriptable topScope;
    private IDocArchiveReader docReader;
    private IDocArchiveWriter docWriter;
    private int cacheOption = 1;
    private int cacheCount = 0;
    private ModuleHandle moduleHandle;

    public DataSessionContext(int mode) throws BirtException {
        this(mode, null, null);
    }

    public DataSessionContext(int mode, ModuleHandle moduleHandle) throws BirtException {
        this(mode, moduleHandle, null);
    }

    public DataSessionContext(int mode, ModuleHandle moduleHandle, Scriptable topScope) throws BirtException {
        if (mode != 1 && mode != 2 && mode != 3) {
            throw new AdapterException("adaptor.invalid.mode", new Integer(mode));
        }
        this.mode = mode;
        this.topScope = topScope;
        this.hasExternalScope = topScope != null;
        this.moduleHandle = moduleHandle;
    }

    public void setDocumentReader(IDocArchiveReader reader) {
        this.docReader = reader;
    }

    public void setDocumentWriter(IDocArchiveWriter writer) {
        this.docWriter = writer;
    }

    public void setCacheOption(int option, int cacheCount) throws BirtException {
        if (option != 1 && option != 2 && option != 3) {
            throw new AdapterException("invalid.cache.option", new Integer(option));
        }
        this.cacheOption = option;
        this.cacheCount = cacheCount;
    }

    public DataEngineContext getDataEngineContext() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)this.mode, (Scriptable)this.getTopScope(), (IDocArchiveReader)this.docReader, (IDocArchiveWriter)this.docWriter);
        context.setCacheOption(this.cacheOption, this.cacheCount);
        return context;
    }

    public boolean hasExternalScope() {
        return this.hasExternalScope;
    }

    public Scriptable getTopScope() {
        if (this.topScope == null) {
            Context cx = Context.enter();
            this.topScope = new DataAdapterTopLevelScope(cx, this.moduleHandle);
            Context.exit();
        }
        return this.topScope;
    }

    public ModuleHandle getModuleHandle() {
        return this.moduleHandle;
    }
}

