/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;
import org.eclipse.birt.report.data.adapter.impl.DataSetMetaDataHelper;
import org.eclipse.birt.report.data.adapter.impl.ModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.QueryExecutionHelper;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;

public class DataRequestSessionImpl
extends DataRequestSession {
    private DataEngine dataEngine;
    private IModelAdapter modelAdaptor;
    private DataSessionContext sessionContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataRequestSessionImpl(DataSessionContext context) throws BirtException {
        if (context == null) {
            throw new AdapterException("context.null.error");
        }
        this.dataEngine = DataEngine.newDataEngine((DataEngineContext)context.getDataEngineContext());
        this.modelAdaptor = new ModelAdapter(context);
        this.sessionContext = context;
    }

    public void defineDataSource(IBaseDataSourceDesign design) throws BirtException {
        this.dataEngine.defineDataSource(design);
    }

    public void defineDataSet(IBaseDataSetDesign design) throws BirtException {
        this.dataEngine.defineDataSet(design);
    }

    public IResultMetaData getDataSetMetaData(String dataSetName, boolean useCache) throws BirtException {
        return this.getDataSetMetaData(this.sessionContext.getModuleHandle().findDataSet(dataSetName), useCache);
    }

    public IResultMetaData getDataSetMetaData(DataSetHandle dataSetHandle, boolean useCache) throws BirtException {
        return new DataSetMetaDataHelper(this.dataEngine, this.modelAdaptor, this.sessionContext.getModuleHandle()).getDataSetMetaData(dataSetHandle, useCache);
    }

    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        return this.getColumnValueSet(dataSet, inputParamBindings, columnBindings, boundColumnName, null);
    }

    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName, IRequestInfo requestInfo) throws BirtException {
        IQueryResults queryResults = this.getGroupingQueryResults(dataSet, inputParamBindings, columnBindings, boundColumnName);
        IResultIterator resultIt = queryResults.getResultIterator();
        int maxRowCount = -1;
        if (requestInfo != null) {
            resultIt.moveTo(requestInfo.getStartRow());
            maxRowCount = requestInfo.getMaxRow();
        }
        ArrayList<Object> values = new ArrayList<Object>();
        while (resultIt.next() && maxRowCount != 0) {
            Object value = resultIt.getValue(boundColumnName);
            values.add(value);
            resultIt.skipToEnd(1);
            --maxRowCount;
        }
        resultIt.close();
        queryResults.close();
        return values;
    }

    public IResultMetaData refreshMetaData(DataSetHandle dataSetHandle) throws BirtException {
        return new DataSetMetaDataHelper(this.dataEngine, this.modelAdaptor, this.sessionContext.getModuleHandle()).refreshMetaData(dataSetHandle);
    }

    public IQueryResults executeQuery(QueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt) throws BirtException {
        return new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.sessionContext.getModuleHandle()).executeQuery(queryDefn, paramBindingIt, filterIt, bindingIt);
    }

    public IQueryResults getQueryResults(String queryResultID) throws BirtException {
        return this.dataEngine.getQueryResults(queryResultID);
    }

    public void clearCache(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        this.dataEngine.clearCache(dataSource, dataSet);
    }

    public IPreparedQuery prepare(IQueryDefinition query, Map appContext) throws BirtException {
        return this.dataEngine.prepare(query, appContext);
    }

    public void closeDataSource(String dataSourceName) throws BirtException {
        this.dataEngine.closeDataSource(dataSourceName);
    }

    public IModelAdapter getModelAdaptor() {
        return this.modelAdaptor;
    }

    public void shutdown() {
        this.dataEngine.shutdown();
        this.dataEngine = null;
    }

    private IQueryResults getGroupingQueryResults(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        if (!$assertionsDisabled && dataSet == null) {
            throw new AssertionError();
        }
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataSet.getQualifiedName());
        GroupDefinition group = new GroupDefinition();
        group.setKeyColumn(boundColumnName);
        query.addGroup(group);
        query.setUsesDetails(false);
        ModuleHandle moduleHandle = this.sessionContext.getModuleHandle();
        if (moduleHandle == null) {
            moduleHandle = dataSet.getModuleHandle();
        }
        QueryExecutionHelper execHelper = new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, moduleHandle);
        IQueryResults results = execHelper.executeQuery(query, inputParamBindings, null, columnBindings);
        return results;
    }

    static {
        $assertionsDisabled = !DataRequestSessionImpl.class.desiredAssertionStatus();
    }
}

