/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.DataExtractionTask;
import org.eclipse.birt.report.engine.api.impl.EngineLogger;
import org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.impl.RenderTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.RunAndRenderTask;
import org.eclipse.birt.report.engine.api.impl.RunTask;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportEngineHelper {
    protected static Logger logger;
    private IReportEngine engine;
    private ExtensionManager extensionMgr;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportEngineHelper(IReportEngine engine) {
        this.engine = engine;
        this.extensionMgr = ExtensionManager.getInstance();
    }

    public IReportRunnable openReportDesign(String designName) throws EngineException {
        return this.openReportDesign(designName, (IResourceLocator)null);
    }

    public IReportRunnable openReportDesign(String designName, IResourceLocator locator) throws EngineException {
        ReportDesignHandle designHandle;
        File file = new File(designName);
        if (!file.exists()) {
            logger.log(Level.SEVERE, "{0} not found!", file.getAbsolutePath());
            throw new EngineException("Error.DesignFileNotFound", designName);
        }
        try {
            EngineConfig config;
            String resourcePath = null;
            if (locator == null && (config = this.engine.getConfig()) != null) {
                locator = config.getResourceLocator();
                resourcePath = config.getResourcePath();
            }
            ReportParser parser = new ReportParser(locator, resourcePath);
            designHandle = parser.getDesignHandle(designName, null);
        }
        catch (DesignFileException e) {
            logger.log(Level.SEVERE, "invalid design file {0}", file.getAbsolutePath());
            throw new EngineException("Error.InvalidDesignFile", designName, (Throwable)e);
        }
        if (!$assertionsDisabled && designHandle == null) {
            throw new AssertionError();
        }
        ReportRunnable runnable = new ReportRunnable(designHandle);
        runnable.setReportName(designName);
        runnable.setReportEngine(this.engine);
        return runnable;
    }

    public IReportRunnable openReportDesign(InputStream designStream) throws EngineException {
        return this.openReportDesign("<stream>", designStream);
    }

    public IReportRunnable openReportDesign(String designName, InputStream designStream) throws EngineException {
        return this.openReportDesign(designName, designStream, null);
    }

    public IReportRunnable openReportDesign(String designName, InputStream designStream, IResourceLocator locator) throws EngineException {
        ReportDesignHandle designHandle;
        try {
            EngineConfig config;
            String resourcePath = null;
            if (locator == null && (config = this.engine.getConfig()) != null) {
                locator = config.getResourceLocator();
                resourcePath = config.getResourcePath();
            }
            ReportParser parser = new ReportParser(locator, resourcePath);
            designHandle = parser.getDesignHandle(designName, designStream);
        }
        catch (DesignFileException e) {
            logger.log(Level.SEVERE, "invalid design file {0}", designName);
            throw new EngineException("Error.InvalidDesignFile", designName, (Throwable)e);
        }
        if (!$assertionsDisabled && designHandle == null) {
            throw new AssertionError();
        }
        ReportRunnable runnable = new ReportRunnable(designHandle);
        runnable.setReportName(designName);
        runnable.setReportEngine(this.engine);
        return runnable;
    }

    public IReportRunnable openReportDesign(ReportDesignHandle designHandle) throws EngineException {
        ReportRunnable ret = new ReportRunnable(designHandle);
        ret.setReportName(designHandle.getFileName());
        ret.setReportEngine(this.engine);
        return ret;
    }

    public IRunAndRenderTask createRunAndRenderTask(IReportRunnable reportRunnable) {
        return new RunAndRenderTask(this.engine, reportRunnable);
    }

    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable reportRunnable) {
        return new GetParameterDefinitionTask(this.engine, reportRunnable);
    }

    public String[] getSupportedFormats() {
        return this.extensionMgr.getSupportedFormat().toArray(new String[0]);
    }

    public String getMIMEType(String format) {
        return this.extensionMgr.getMIMEType(format);
    }

    public void setupLogging(String dest, Level level) {
        EngineLogger.startEngineLogging(dest, level);
    }

    public void stopLogging() {
        EngineLogger.stopEngineLogging();
    }

    public void changeLogLevel(Level newLevel) {
        EngineLogger.changeLogLevel(newLevel);
    }

    public IReportDocument openReportDocument(String docArchiveName) throws EngineException {
        return this.openReportDocument(null, docArchiveName);
    }

    public IReportDocument openReportDocument(String systemId, String docArchiveName) throws EngineException {
        return this.openReportDocument(systemId, docArchiveName, null);
    }

    public IReportDocument openReportDocument(String systemId, String docArchiveName, IResourceLocator locator) throws EngineException {
        Object reader = null;
        try {
            File file = new File(docArchiveName);
            reader = file.exists() ? (file.isDirectory() ? new FolderArchiveReader(docArchiveName) : new FileArchiveReader(docArchiveName)) : (docArchiveName.endsWith("\\") || docArchiveName.endsWith("/") ? new FolderArchiveReader(docArchiveName) : new FileArchiveReader(docArchiveName));
        }
        catch (IOException e) {
            throw new EngineException(e.getLocalizedMessage());
        }
        return this.openReportDocument(systemId, (IDocArchiveReader)reader, locator);
    }

    public IReportDocument openReportDocument(String systemId, IDocArchiveReader archive, IResourceLocator locator) throws EngineException {
        ReportDocumentReader reader = new ReportDocumentReader(systemId, this.engine, archive);
        reader.setResourceLocator(locator);
        return reader;
    }

    public IRunTask createRunTask(IReportRunnable runnable) {
        return new RunTask(this.engine, runnable);
    }

    public IRenderTask createRenderTask(IReportDocument reportDoc) {
        IReportRunnable runnable = reportDoc.getReportRunnable();
        return new RenderTask(this.engine, runnable, reportDoc);
    }

    public IDataExtractionTask createDataExtractionTask(IReportDocument reportDoc) {
        try {
            IReportRunnable runnable = reportDoc.getReportRunnable();
            return new DataExtractionTask(this.engine, runnable, reportDoc);
        }
        catch (EngineException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        $assertionsDisabled = !ReportEngineHelper.class.desiredAssertionStatus();
        logger = Logger.getLogger(ReportEngineHelper.class.getName());
    }
}

