/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchive;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.AbstractRunTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.emitter.EngineEmitterServices;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.presentation.ReportDocumentBuilder;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class RunTask
extends AbstractRunTask
implements IRunTask {
    private IDocArchiveWriter archive;
    private ReportDocumentWriter writer;
    private IPageHandler pageHandler;
    private ReportDocumentBuilder documentBuilder;

    public RunTask(IReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable);
        this.executionContext.setFactoryMode(true);
        this.executionContext.setPresentationMode(false);
    }

    public void setPageHandler(IPageHandler callback) {
        this.pageHandler = callback;
    }

    public void run(String reportDocName) throws EngineException {
        if (reportDocName == null || reportDocName.length() == 0) {
            throw new EngineException("Report document name is not specified when running a report.");
        }
        try {
            File file = new File(reportDocName);
            this.archive = file.exists() ? (file.isDirectory() ? new FolderArchiveWriter(reportDocName) : new FileArchiveWriter(reportDocName)) : (reportDocName.endsWith("\\") || reportDocName.endsWith("/") ? new FolderArchiveWriter(reportDocName) : new FileArchiveWriter(reportDocName));
        }
        catch (IOException e) {
            throw new EngineException(e.getLocalizedMessage());
        }
        this.run(this.archive);
    }

    public void run(IDocArchiveWriter archive) throws EngineException {
        if (archive == null) {
            throw new EngineException("Report archive is not specified when running a report.");
        }
        this.archive = archive;
        this.doRun();
    }

    private void openReportDocument() throws EngineException {
        try {
            this.archive.initialize();
            this.writer = new ReportDocumentWriter(this.engine, this.archive);
            this.executionContext.setReportDocWriter(this.writer);
        }
        catch (IOException ex) {
            throw new EngineException("Can't open the report archive.", ex);
        }
    }

    private void closeReportDocument() {
        this.writer.close();
    }

    private void initializeContentEmitter(IContentEmitter emitter, IReportExecutor executor) {
        EngineEmitterServices services = new EngineEmitterServices(this);
        EngineConfig config = this.engine.getConfig();
        if (config != null) {
            HashMap emitterConfigs = config.getEmitterConfigs();
            services.setEmitterConfig(emitterConfigs);
        }
        services.setRenderOption(this.renderOptions);
        services.setExecutor(executor);
        services.setRenderContext(this.appContext);
        services.setReportRunnable(this.runnable);
        emitter.initialize(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws EngineException {
        this.setRunningFlag(true);
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        if (!this.validateParameters()) {
            this.setRunningFlag(false);
            throw new EngineException("Error.InvalidParameter");
        }
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        this.openReportDocument();
        try {
            try {
                this.writer.saveDesign(reportDesign);
                this.writer.saveParamters(this.inputValues);
                this.executionContext.openDataEngine();
                RunTask runTask = this;
                synchronized (runTask) {
                    if (!this.executionContext.isCanceled()) {
                        this.documentBuilder = new ReportDocumentBuilder(this.executionContext, this.writer);
                    }
                }
                if (this.documentBuilder != null) {
                    if (this.pageHandler != null) {
                        this.documentBuilder.setPageHandler(this.pageHandler);
                    }
                    IContentEmitter emitter = this.documentBuilder.getContentEmitter();
                    ReportExecutor executor = new ReportExecutor(this.executionContext, reportDesign, emitter);
                    LocalizedReportExecutor lExecutor = new LocalizedReportExecutor(this.executionContext, executor);
                    this.executionContext.setExecutor(lExecutor);
                    this.initializeContentEmitter(emitter, lExecutor);
                    this.documentBuilder.build();
                }
                this.executionContext.closeDataEngine();
                this.writer.savePersistentObjects(this.executionContext.getGlobalBeans());
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
                throw new EngineException("Error happended while running the report", ex);
            }
            catch (OutOfMemoryError err) {
                log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
                throw err;
            }
            Object var6_8 = null;
            this.documentBuilder = null;
            this.closeReportDocument();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.documentBuilder = null;
            this.closeReportDocument();
            this.closeFactory();
            this.setRunningFlag(false);
            throw throwable;
        }
        this.closeFactory();
        this.setRunningFlag(false);
    }

    public void close() {
        super.close();
    }

    public void run(FolderArchive fArchive) throws EngineException {
        this.setDataSource((IDocArchiveReader)fArchive);
        this.run((IDocArchiveWriter)fArchive);
    }

    protected void doCancel() {
        super.doCancel();
        if (this.documentBuilder != null) {
            this.documentBuilder.cancel();
        }
    }
}

