/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;

public class ForeignContent
extends AbstractContent
implements IForeignContent {
    protected String rawType;
    protected Object rawValue;
    protected static final int FIELD_ROW_TYPE = 400;
    protected static final int FIELD_ROWVALUE = 401;

    public int getContentType() {
        return 4;
    }

    public ForeignContent(ReportContent report) {
        super(report);
    }

    public ForeignContent(IContent content) {
        super(content);
    }

    public Object accept(IContentVisitor visitor, Object value) {
        return visitor.visitForeign(this, value);
    }

    public String getRawType() {
        return this.rawType;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public void setRawType(String rawType) {
        this.rawType = rawType;
    }

    public void setRawValue(Object rawValue) {
        this.rawValue = rawValue;
    }

    public static String getTextRawType(String contentType, Object content) {
        String text;
        if ("plain".equals(contentType)) {
            return "text/plaintext";
        }
        if ("html".equals(contentType)) {
            return "text/html";
        }
        String string = text = content == null ? "" : content.toString().trim();
        if (text.length() > 6 && "<html>".equalsIgnoreCase(text.substring(0, 6))) {
            return "text/html";
        }
        return "text/plaintext";
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.rawType != null) {
            IOUtil.writeInt((OutputStream)out, (int)400);
            IOUtil.writeString((DataOutputStream)out, (String)this.rawType);
        }
        if (this.rawValue != null) {
            IOUtil.writeInt((OutputStream)out, (int)401);
            IOUtil.writeObject((DataOutputStream)out, (Object)this.rawValue);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 400: {
                this.rawType = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 401: {
                this.rawValue = IOUtil.readObject((DataInputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in);
            }
        }
    }
}

