/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value;

import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class ListValue
extends Value
implements CSSValueList {
    protected int length;
    protected CSSValue[] items = new CSSValue[5];
    protected char separator = (char)44;

    public ListValue() {
    }

    public ListValue(char s) {
        this.separator = s;
    }

    public char getSeparatorChar() {
        return this.separator;
    }

    public short getCssValueType() {
        return 2;
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        if (this.length > 0) {
            sb.append(this.getCssText(this.items[0]));
        }
        for (int i = 1; i < this.length; ++i) {
            sb.append(this.separator);
            sb.append(this.getCssText(this.items[i]));
        }
        return sb.toString();
    }

    protected String getCssText(CSSValue value) {
        CSSPrimitiveValue pvalue;
        String cssText = value.getCssText();
        if (value.getCssValueType() == 1 && (pvalue = (CSSPrimitiveValue)value).getPrimitiveType() == 19) {
            char q = cssText.indexOf(34) != -1 ? (char)'\'' : '\"';
            return q + cssText + q;
        }
        return cssText;
    }

    public int getLength() throws DOMException {
        return this.length;
    }

    public CSSValue item(int index) throws DOMException {
        return this.items[index];
    }

    public String toString() {
        return this.getCssText();
    }

    public void append(CSSValue v) {
        if (this.length == this.items.length) {
            CSSValue[] t = new CSSValue[this.length * 2];
            for (int i = 0; i < this.length; ++i) {
                t[i] = this.items[i];
            }
            this.items = t;
        }
        this.items[this.length++] = v;
    }

    public boolean equals(Object value) {
        if (value instanceof ListValue) {
            ListValue l = (ListValue)value;
            if (l.length == this.length) {
                for (int i = 0; i < this.length; ++i) {
                    CSSValue i1 = this.items[i];
                    CSSValue i2 = l.items[i];
                    if (i1 == i2 || i1 != null && i1.equals(i2)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

