/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseTransform;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.adapter.IColumnBinding;
import org.eclipse.birt.report.engine.adapter.ITotalExprBindings;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IReportItemQuery;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.MultiLineItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.RuleDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class ReportQueryBuilder {
    protected static Logger logger = Logger.getLogger(ReportQueryBuilder.class.getName());
    private ExpressionUtil expressionUtil = new ExpressionUtil();

    public void build(Report report, ExecutionContext context) {
        new QueryBuilderVisitor().buildQuery(report, context);
    }

    private int toDteFilterOperator(String modelOpr) {
        if (modelOpr.equals("eq")) {
            return 1;
        }
        if (modelOpr.equals("ne")) {
            return 2;
        }
        if (modelOpr.equals("lt")) {
            return 3;
        }
        if (modelOpr.equals("le")) {
            return 4;
        }
        if (modelOpr.equals("ge")) {
            return 5;
        }
        if (modelOpr.equals("gt")) {
            return 6;
        }
        if (modelOpr.equals("between")) {
            return 7;
        }
        if (modelOpr.equals("not-between")) {
            return 8;
        }
        if (modelOpr.equals("is-null")) {
            return 9;
        }
        if (modelOpr.equals("is-not-null")) {
            return 10;
        }
        if (modelOpr.equals("is-true")) {
            return 11;
        }
        if (modelOpr.equals("is-false")) {
            return 12;
        }
        if (modelOpr.equals("like")) {
            return 13;
        }
        if (modelOpr.equals("top-n")) {
            return 14;
        }
        if (modelOpr.equals("bottom-n")) {
            return 15;
        }
        if (modelOpr.equals("top-percent")) {
            return 16;
        }
        if (modelOpr.equals("bottom-percent")) {
            return 17;
        }
        if (modelOpr.equals("not-like")) {
            return 20;
        }
        if (modelOpr.equals("not-match")) {
            return 21;
        }
        return 0;
    }

    protected class QueryBuilderVisitor
    extends DefaultReportItemVisitorImpl {
        protected HashMap queryIDs;
        protected HashMap resultMetaData;
        protected Collection queries;
        protected LinkedList queryStack = new LinkedList();
        protected LinkedList currentConditionStack = new LinkedList();
        protected LinkedList reportItemQueryStack;
        protected Report report;
        protected ExecutionContext context;
        protected int maxRows = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected QueryBuilderVisitor() {
        }

        public void buildQuery(Report report, ExecutionContext context) {
            int i;
            EngineConfig engineConfig;
            IReportEngine engine;
            this.report = report;
            this.context = context;
            if (null != this.context && null != (engine = this.context.getEngine()) && null != (engineConfig = engine.getConfig())) {
                this.maxRows = engineConfig.getMaxRowsPerQuery();
            }
            this.queries = report.getQueries();
            this.queries.clear();
            this.queryIDs = report.getQueryIDs();
            this.queryIDs.clear();
            this.resultMetaData = report.getResultMetaData();
            this.resultMetaData.clear();
            for (i = 0; i < report.getPageSetup().getMasterPageCount(); ++i) {
                int j;
                MasterPageDesign masterPage = report.getPageSetup().getMasterPage(i);
                if (masterPage == null) continue;
                SimpleMasterPageDesign pageDesign = (SimpleMasterPageDesign)masterPage;
                for (j = 0; j < pageDesign.getHeaderCount(); ++j) {
                    pageDesign.getHeader(j).accept(this, null);
                }
                for (j = 0; j < pageDesign.getFooterCount(); ++j) {
                    pageDesign.getFooter(j).accept(this, null);
                }
            }
            for (i = 0; i < report.getContentCount(); ++i) {
                report.getContent(i).accept(this, null);
            }
        }

        private BaseQueryDefinition prepareVisit(ReportItemDesign item) {
            BaseQueryDefinition tempQuery = this.createQuery(item);
            if (tempQuery != null) {
                this.pushQuery((IBaseTransform)tempQuery);
            }
            this.transformExpressions(item);
            return tempQuery;
        }

        private void finishVisit(BaseQueryDefinition query) {
            if (query != null) {
                this.popQuery();
            }
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            BaseQueryDefinition query = this.prepareVisit(container);
            for (int i = 0; i < container.getItemCount(); ++i) {
                container.getItem(i).accept(this, value);
            }
            this.finishVisit(query);
            return value;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            BaseQueryDefinition query = this.prepareVisit(grid);
            for (int i = 0; i < grid.getRowCount(); ++i) {
                grid.getRow(i).accept(this, value);
            }
            this.finishVisit(query);
            return value;
        }

        public Object visitImageItem(ImageItemDesign image, Object value) {
            BaseQueryDefinition query = this.prepareVisit(image);
            if (image.getImageSource() == 2) {
                String newImageExpression = this.transformExpression(image.getImageExpression());
                String newImageFormat = this.transformExpression(image.getImageFormat());
                image.setImageExpression(newImageExpression, newImageFormat);
            } else if (image.getImageSource() == 0 || image.getImageSource() == 3) {
                String newImageUri = this.transformExpression(image.getImageUri());
                image.setImageUri(newImageUri);
            }
            this.finishVisit(query);
            return value;
        }

        public Object visitLabelItem(LabelItemDesign label, Object value) {
            BaseQueryDefinition query = this.prepareVisit(label);
            this.finishVisit(query);
            return value;
        }

        public Object visitExtendedItem(ExtendedItemDesign item, Object value) {
            ExtendedItemHandle handle = (ExtendedItemHandle)item.getHandle();
            String tagName = handle.getExtensionName();
            IReportItemQuery itemQuery = ExtensionManager.getInstance().createQueryItem(tagName);
            IBaseQueryDefinition[] queries = null;
            BaseQueryDefinition parentQuery = this.getParentQuery();
            IBaseTransform parentTrans = this.getTransform();
            if (itemQuery != null) {
                try {
                    itemQuery.setModelObject(handle);
                    queries = itemQuery.getReportQueries((IBaseQueryDefinition)parentQuery);
                }
                catch (BirtException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
                if (queries != null) {
                    IBaseQueryDefinition query;
                    item.setQueries(queries);
                    for (int i = 0; i < queries.length; ++i) {
                        if (queries[i] == null) continue;
                        if (queries[i] instanceof IQueryDefinition) {
                            this.queryIDs.put(queries[i], String.valueOf(item.getID()) + "_" + String.valueOf(i));
                            this.queries.add(queries[i]);
                            ResultMetaData metaData = new ResultMetaData((IQueryDefinition)queries[i]);
                            this.resultMetaData.put(queries[i], metaData);
                            this.registerQueryAndElement(queries[i], item);
                            continue;
                        }
                        if (!(queries[i] instanceof ISubqueryDefinition) || parentTrans == null) continue;
                        parentTrans.getSubqueries().add(queries[i]);
                    }
                    if (queries.length > 0 && (query = queries[0]) != null) {
                        this.transformExpressions(item);
                    }
                }
            }
            BaseQueryDefinition query = this.prepareVisit(item);
            this.finishVisit(query);
            return value;
        }

        public Object visitListItem(ListItemDesign list, Object value) {
            BaseQueryDefinition query = this.prepareVisit(list);
            if (query == null) {
                this.pushCurrentCondition(true);
                this.handleListingBand(list.getHeader(), value);
                this.popCurrentCondition();
                this.pushCurrentCondition(true);
                this.handleListingBand(list.getFooter(), value);
                this.popCurrentCondition();
            } else {
                this.pushReportItemQuery((IBaseQueryDefinition)query);
                this.transformExpressions(list);
                this.pushCurrentCondition(true);
                this.handleListingBand(list.getHeader(), value);
                SlotHandle groupsSlot = ((ListHandle)list.getHandle()).getGroups();
                for (int i = 0; i < list.getGroupCount(); ++i) {
                    this.handleListingGroup(list.getGroup(i), (GroupHandle)groupsSlot.get(i), value);
                }
                this.popCurrentCondition();
                BandDesign detail = list.getDetail();
                if (detail != null && detail.getContentCount() != 0) {
                    query.setUsesDetails(true);
                }
                this.pushCurrentCondition(false);
                this.handleListingBand(list.getDetail(), value);
                this.popCurrentCondition();
                this.pushCurrentCondition(true);
                this.handleListingBand(list.getFooter(), value);
                this.popCurrentCondition();
                this.popReportItemQuery();
            }
            this.finishVisit(query);
            return value;
        }

        public Object visitTextItem(TextItemDesign text, Object value) {
            BaseQueryDefinition query = this.prepareVisit(text);
            HashMap exprs = text.getExpressions();
            if (exprs != null) {
                Iterator ite = exprs.entrySet().iterator();
                while (ite.hasNext()) {
                    Map.Entry entry = ite.next();
                    if (!$assertionsDisabled && !(entry.getValue() instanceof String)) {
                        throw new AssertionError();
                    }
                    String newExpr = this.transformExpression(entry.getValue().toString());
                    entry.setValue(newExpr);
                }
            }
            this.finishVisit(query);
            return value;
        }

        public void handleColumn(ColumnDesign column) {
            this.transformColumnExpressions(column);
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            BaseQueryDefinition query = this.prepareVisit(table);
            if (query == null) {
                this.pushCurrentCondition(true);
                this.handleListingBand(table.getHeader(), value);
                this.popCurrentCondition();
                this.pushCurrentCondition(true);
                this.handleListingBand(table.getFooter(), value);
                this.popCurrentCondition();
            } else {
                this.transformExpressions(table);
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    this.handleColumn(table.getColumn(i));
                }
                this.pushCurrentCondition(true);
                this.handleListingBand(table.getHeader(), value);
                SlotHandle groupsSlot = ((TableHandle)table.getHandle()).getGroups();
                for (int i = 0; i < table.getGroupCount(); ++i) {
                    this.handleListingGroup(table.getGroup(i), (GroupHandle)groupsSlot.get(i), value);
                }
                this.popCurrentCondition();
                BandDesign detail = table.getDetail();
                if (detail != null && detail.getContentCount() != 0) {
                    query.setUsesDetails(true);
                }
                this.pushCurrentCondition(false);
                this.handleListingBand(table.getDetail(), value);
                this.popCurrentCondition();
                this.pushCurrentCondition(true);
                this.handleListingBand(table.getFooter(), value);
                this.popCurrentCondition();
            }
            this.finishVisit(query);
            return value;
        }

        private void registerQueryAndElement(IBaseQueryDefinition query, ReportItemDesign reportItem) {
            if (!($assertionsDisabled || query != null && reportItem != null)) {
                throw new AssertionError();
            }
            HashMap map = this.report.getReportItemToQueryMap();
            if (!$assertionsDisabled && map == null) {
                throw new AssertionError();
            }
            map.put(query, reportItem);
        }

        public Object visitMultiLineItem(MultiLineItemDesign multiLine, Object value) {
            BaseQueryDefinition query = this.prepareVisit(multiLine);
            String newContent = this.transformExpression(multiLine.getContent());
            multiLine.setContent(newContent);
            this.finishVisit(query);
            return value;
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            BaseQueryDefinition query = this.prepareVisit(data);
            String newValue = this.transformExpression(data.getValue());
            data.setValue(newValue);
            this.finishVisit(query);
            return value;
        }

        public void handleListingBand(BandDesign band, Object value) {
            if (band != null) {
                for (int i = 0; i < band.getContentCount(); ++i) {
                    band.getContent(i).accept(this, value);
                }
            }
        }

        protected void handleListingGroup(GroupDesign group, GroupHandle handle, Object value) {
            IGroupDefinition groupDefn = this.handleGroup(group, handle);
            this.pushQuery((IBaseTransform)groupDefn);
            this.handleListingBand(group.getHeader(), value);
            this.handleListingBand(group.getFooter(), value);
            this.popQuery();
        }

        protected IGroupDefinition handleGroup(GroupDesign group, GroupHandle handle) {
            GroupDefinition groupDefn = new GroupDefinition(group.getName());
            groupDefn.setKeyExpression(handle.getKeyExpr());
            String interval = handle.getInterval();
            if (interval != null) {
                groupDefn.setInterval(this.parseInterval(interval));
            }
            groupDefn.setIntervalRange(handle.getIntervalRange());
            groupDefn.setIntervalStart((Object)handle.getIntervalBase());
            String direction = handle.getSortDirection();
            if (direction != null) {
                groupDefn.setSortDirection(this.parseSortDirection(direction));
            }
            groupDefn.getSorts().addAll(this.createSorts(handle));
            groupDefn.getFilters().addAll(this.createFilters(handle));
            this.getParentQuery().getGroups().add(groupDefn);
            return groupDefn;
        }

        public Object visitRow(RowDesign row, Object value) {
            BaseQueryDefinition query = this.prepareVisit(row);
            for (int i = 0; i < row.getCellCount(); ++i) {
                CellDesign cell = row.getCell(i);
                cell.accept(this, value);
            }
            this.finishVisit(query);
            return value;
        }

        public Object visitCell(CellDesign cell, Object value) {
            BaseQueryDefinition query = this.prepareVisit(cell);
            for (int i = 0; i < cell.getContentCount(); ++i) {
                cell.getContent(i).accept(this, value);
            }
            this.finishVisit(query);
            return value;
        }

        protected void pushReportItemQuery(IBaseQueryDefinition query) {
            if (this.reportItemQueryStack == null) {
                this.reportItemQueryStack = new LinkedList();
            }
            this.reportItemQueryStack.addLast(query);
        }

        protected void popReportItemQuery() {
            if (!$assertionsDisabled && this.reportItemQueryStack.isEmpty()) {
                throw new AssertionError();
            }
            this.reportItemQueryStack.removeLast();
        }

        protected void pushCurrentCondition(boolean currentCondition) {
            this.currentConditionStack.addLast(String.valueOf(currentCondition));
        }

        protected void popCurrentCondition() {
            if (!$assertionsDisabled && this.currentConditionStack.isEmpty()) {
                throw new AssertionError();
            }
            this.currentConditionStack.removeLast();
        }

        protected String getCurrentCondition() {
            if (this.currentConditionStack.isEmpty()) {
                return String.valueOf(false);
            }
            return (String)this.currentConditionStack.getLast();
        }

        protected void pushQuery(IBaseTransform query) {
            this.queryStack.addLast(query);
        }

        protected void popQuery() {
            if (!$assertionsDisabled && this.queryStack.isEmpty()) {
                throw new AssertionError();
            }
            this.queryStack.removeLast();
        }

        protected IBaseTransform getTransform() {
            if (this.queryStack.isEmpty()) {
                return null;
            }
            return (IBaseTransform)this.queryStack.getLast();
        }

        protected BaseQueryDefinition getParentQuery() {
            if (this.queryStack.isEmpty()) {
                return null;
            }
            for (int i = this.queryStack.size() - 1; i >= 0; --i) {
                if (!(this.queryStack.get(i) instanceof BaseQueryDefinition)) continue;
                return (BaseQueryDefinition)this.queryStack.get(i);
            }
            return null;
        }

        protected GroupDefinition getCurrentGroup() {
            if (this.queryStack.isEmpty()) {
                return null;
            }
            if (this.queryStack.getLast() instanceof GroupDefinition) {
                return (GroupDefinition)this.queryStack.getLast();
            }
            return null;
        }

        protected String getCurrentGroupName() {
            GroupDefinition group = this.getCurrentGroup();
            if (group != null) {
                return group.getName();
            }
            return null;
        }

        protected void addColumBinding(IBaseQueryDefinition transfer, ComputedColumnHandle binding) {
            String name = binding.getName();
            String expr = binding.getExpression();
            String type = binding.getDataType();
            int dbType = ModelDteApiAdapter.toDteDataType(type);
            ScriptExpression dbExpr = new ScriptExpression(expr, dbType);
            dbExpr.setGroupName(binding.getAggregrateOn());
            transfer.getResultSetExpressions().put(name, dbExpr);
        }

        protected BaseQueryDefinition createQuery(ReportItemDesign item) {
            DesignElementHandle handle = item.getHandle();
            if (!(handle instanceof ReportItemHandle)) {
                if (!this.needQuery(item)) {
                    return null;
                }
                return this.createSubQuery(item);
            }
            ReportItemHandle designHandle = (ReportItemHandle)handle;
            DataSetHandle dsHandle = designHandle.getDataSet();
            if (dsHandle == null) {
                String dsName = (String)designHandle.getProperty("dataSet");
                if (dsName != null && dsName.length() > 0) {
                    this.context.addException(item.getHandle(), new EngineException("Error.UndefinedDatasetError", dsName));
                }
                if (!this.needQuery(item)) {
                    return null;
                }
                return this.createSubQuery(item);
            }
            QueryDefinition query = new QueryDefinition(this.getParentQuery());
            query.setDataSetName(dsHandle.getQualifiedName());
            query.getInputParamBindings().addAll(this.createParamBindings(designHandle.paramBindingsIterator()));
            query.setMaxRows(this.maxRows);
            this.queryIDs.put(query, String.valueOf(item.getID()));
            this.queries.add(query);
            this.registerQueryAndElement((IBaseQueryDefinition)query, item);
            Iterator iter = designHandle.columnBindingsIterator();
            while (iter.hasNext()) {
                ComputedColumnHandle binding = (ComputedColumnHandle)iter.next();
                this.addColumBinding((IBaseQueryDefinition)query, binding);
            }
            item.setQuery((IBaseQueryDefinition)query);
            this.addSortAndFilter(item, (BaseQueryDefinition)query);
            ResultMetaData metaData = new ResultMetaData((IQueryDefinition)query);
            this.resultMetaData.put(query, metaData);
            return query;
        }

        private boolean needQuery(ReportItemDesign item) {
            DesignElementHandle handle = item.getHandle();
            if (handle instanceof ReportItemHandle) {
                ReportItemHandle designHandle = (ReportItemHandle)item.getHandle();
                if (designHandle.columnBindingsIterator().hasNext()) {
                    return true;
                }
                if (designHandle instanceof ListingHandle) {
                    return true;
                }
            }
            HighlightDesign highlight = item.getHighlight();
            return this.getParentQuery() == null && highlight != null && highlight.getRuleCount() > 0;
        }

        private void addSortAndFilter(ReportItemDesign item, BaseQueryDefinition query) {
            if (item instanceof ListingDesign) {
                query.getSorts().addAll(this.createSorts((ListingDesign)item));
                query.getFilters().addAll(this.createFilters((ListingDesign)item));
            } else if (item instanceof ExtendedItemDesign) {
                query.getFilters().addAll(this.createFilters((ExtendedItemDesign)item));
            }
        }

        protected BaseQueryDefinition createSubQuery(ReportItemDesign item) {
            QueryDefinition query = null;
            IBaseTransform parentQuery = this.getTransform();
            if (parentQuery == null) {
                query = new QueryDefinition(this.getParentQuery());
                this.queryIDs.put(query, String.valueOf(item.getID()));
                this.queries.add(query);
                this.registerQueryAndElement((IBaseQueryDefinition)query, item);
            } else {
                String name = String.valueOf(item.getID());
                query = new SubqueryDefinition(name);
                parentQuery.getSubqueries().add(query);
                String currentCondition = this.getCurrentCondition();
                if (currentCondition.equals(String.valueOf(true))) {
                    ((SubqueryDefinition)query).setApplyOnGroupFlag(true);
                } else {
                    ((SubqueryDefinition)query).setApplyOnGroupFlag(false);
                }
            }
            query.setMaxRows(this.maxRows);
            item.setQuery((IBaseQueryDefinition)query);
            if (item.getHandle() instanceof ReportItemHandle) {
                ReportItemHandle designHandle = (ReportItemHandle)item.getHandle();
                Iterator iter = designHandle.columnBindingsIterator();
                while (iter.hasNext()) {
                    ComputedColumnHandle binding = (ComputedColumnHandle)iter.next();
                    this.addColumBinding((IBaseQueryDefinition)query, binding);
                }
            }
            this.addSortAndFilter(item, (BaseQueryDefinition)query);
            if (query instanceof IQueryDefinition) {
                ResultMetaData metaData = new ResultMetaData((IQueryDefinition)query);
                this.resultMetaData.put(query, metaData);
            }
            return query;
        }

        protected String getLocalizedString(String resourceKey, String text) {
            if (resourceKey == null) {
                return text;
            }
            String ret = this.report.getMessage(resourceKey, this.context.getLocale());
            if (ret == null) {
                logger.log(Level.SEVERE, "get resource error, resource key:" + resourceKey + " Locale:" + this.context.getLocale().toString());
                return text;
            }
            return ret;
        }

        private IFilterDefinition createFilter(FilterConditionHandle handle) {
            String filterExpr = handle.getExpr();
            if (filterExpr == null || filterExpr.length() == 0) {
                return null;
            }
            String filterOpr = handle.getOperator();
            if (filterOpr == null || filterOpr.length() == 0) {
                return new FilterDefinition((IBaseExpression)new ScriptExpression(filterExpr));
            }
            String column = filterExpr;
            int dteOpr = ModelDteApiAdapter.toDteFilterOperator(filterOpr);
            String operand1 = handle.getValue1();
            String operand2 = handle.getValue2();
            return new FilterDefinition((IBaseExpression)new ConditionalExpression(column, dteOpr, operand1, operand2));
        }

        private ArrayList createFilters(Iterator iter) {
            ArrayList<IFilterDefinition> filters = new ArrayList<IFilterDefinition>();
            if (iter != null) {
                while (iter.hasNext()) {
                    FilterConditionHandle filterHandle = (FilterConditionHandle)iter.next();
                    IFilterDefinition filter = this.createFilter(filterHandle);
                    filters.add(filter);
                }
            }
            return filters;
        }

        public ArrayList createFilters(ListingDesign listing) {
            return this.createFilters(((ListingHandle)listing.getHandle()).filtersIterator());
        }

        public ArrayList createFilters(DataSetHandle dataSet) {
            return this.createFilters(dataSet.filtersIterator());
        }

        public ArrayList createFilters(GroupHandle group) {
            return this.createFilters(group.filtersIterator());
        }

        public ArrayList createFilters(ExtendedItemDesign extendedItem) {
            return this.createFilters(((ExtendedItemHandle)extendedItem.getHandle()).filtersIterator());
        }

        private ISortDefinition createSort(SortKeyHandle handle) {
            SortDefinition sort = new SortDefinition();
            sort.setExpression(handle.getKey());
            sort.setSortDirection(handle.getDirection().equals("asc") ? 0 : 1);
            return sort;
        }

        private ArrayList createSorts(Iterator iter) {
            ArrayList<ISortDefinition> sorts = new ArrayList<ISortDefinition>();
            if (iter != null) {
                while (iter.hasNext()) {
                    SortKeyHandle handle = (SortKeyHandle)iter.next();
                    sorts.add(this.createSort(handle));
                }
            }
            return sorts;
        }

        protected ArrayList createSorts(ListingDesign listing) {
            return this.createSorts(((ListingHandle)listing.getHandle()).sortsIterator());
        }

        protected ArrayList createSorts(GroupHandle group) {
            return this.createSorts(group.sortsIterator());
        }

        protected IInputParameterBinding createParamBinding(ParamBindingHandle handle) {
            if (handle.getExpression() == null) {
                return null;
            }
            ScriptExpression expr = new ScriptExpression(handle.getExpression());
            return new InputParameterBinding(handle.getParamName(), (IBaseExpression)expr);
        }

        protected ArrayList createParamBindings(Iterator iter) {
            ArrayList<IInputParameterBinding> list = new ArrayList<IInputParameterBinding>();
            if (iter != null) {
                while (iter.hasNext()) {
                    ParamBindingHandle modelParamBinding = (ParamBindingHandle)iter.next();
                    IInputParameterBinding binding = this.createParamBinding(modelParamBinding);
                    if (binding == null) continue;
                    list.add(binding);
                }
            }
            return list;
        }

        protected int parseInterval(String interval) {
            if ("year".equals(interval)) {
                return 1;
            }
            if ("month".equals(interval)) {
                return 2;
            }
            if ("week".equals(interval)) {
                return 4;
            }
            if ("quarter".equals(interval)) {
                return 3;
            }
            if ("day".equals(interval)) {
                return 5;
            }
            if ("hour".equals(interval)) {
                return 6;
            }
            if ("minute".equals(interval)) {
                return 7;
            }
            if ("prefix".equals(interval)) {
                return 100;
            }
            if ("second".equals(interval)) {
                return 8;
            }
            if ("interval".equals(interval)) {
                return 99;
            }
            return 0;
        }

        protected int parseSortDirection(String direction) {
            if ("asc".equals(direction)) {
                return 0;
            }
            if ("desc".equals(direction)) {
                return 1;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }

        private void transformExpressions(ReportItemDesign item) {
            BaseQueryDefinition query = this.getParentQuery();
            if (query != null) {
                ITotalExprBindings totalExpressionBindings = this.getNewExpressionBindings(item);
                this.addNewColumnBindings((IBaseQueryDefinition)query, totalExpressionBindings);
                this.replaceOldExpressions(item, totalExpressionBindings);
            }
        }

        protected String transformExpression(String expr) {
            if (expr == null) {
                return null;
            }
            BaseQueryDefinition query = this.getParentQuery();
            if (query != null) {
                ArrayList<String> expressions = new ArrayList<String>();
                expressions.add(expr);
                ITotalExprBindings totalExpressionBinding = ReportQueryBuilder.this.expressionUtil.prepareTotalExpressions(expressions, this.getCurrentGroupName());
                this.addNewColumnBindings((IBaseQueryDefinition)query, totalExpressionBinding);
                List newExpressions = totalExpressionBinding.getNewExpression();
                return (String)newExpressions.get(0);
            }
            return expr;
        }

        private void transformColumnExpressions(ColumnDesign column) {
            int i;
            HighlightDesign highlights;
            BaseQueryDefinition query = this.getParentQuery();
            if (query == null) {
                return;
            }
            ArrayList<String> expressions = new ArrayList<String>();
            VisibilityDesign visibilities = column.getVisibility();
            if (visibilities != null) {
                for (int i2 = 0; i2 < visibilities.count(); ++i2) {
                    expressions.add(visibilities.getRule(i2).getExpression());
                }
            }
            if ((highlights = column.getHighlight()) != null) {
                for (int i3 = 0; i3 < highlights.getRuleCount(); ++i3) {
                    expressions.add((String)this.createConditionalExpression(highlights.getRule(i3)));
                }
            }
            ITotalExprBindings totalExpressionBindings = ReportQueryBuilder.this.expressionUtil.prepareTotalExpressions(expressions, this.getCurrentGroupName());
            this.addNewColumnBindings((IBaseQueryDefinition)query, totalExpressionBindings);
            int expressionIndex = 0;
            List newExpressions = totalExpressionBindings.getNewExpression();
            if (visibilities != null) {
                for (i = 0; i < visibilities.count(); ++i) {
                    visibilities.getRule(i).setExpression((String)newExpressions.get(expressionIndex++));
                }
            }
            if (highlights != null) {
                for (i = 0; i < highlights.getRuleCount(); ++i) {
                    highlights.getRule(i).setConditionExpr((String)newExpressions.get(expressionIndex++));
                }
            }
        }

        private void replaceOldExpressions(ReportItemDesign item, ITotalExprBindings totalExpressionBindings) {
            ActionDesign action;
            Map namedExpressions;
            VisibilityDesign visibilities;
            MapDesign maps;
            int expressionIndex = 0;
            List newExpressions = totalExpressionBindings.getNewExpression();
            item.setTOC((String)newExpressions.get(expressionIndex++));
            item.setBookmark((String)newExpressions.get(expressionIndex++));
            item.setOnCreate((String)newExpressions.get(expressionIndex++));
            item.setOnRender((String)newExpressions.get(expressionIndex++));
            item.setOnPageBreak((String)newExpressions.get(expressionIndex++));
            HighlightDesign highlights = item.getHighlight();
            if (highlights != null) {
                for (int i = 0; i < highlights.getRuleCount(); ++i) {
                    highlights.getRule(i).setConditionExpr((String)newExpressions.get(expressionIndex++));
                }
            }
            if ((maps = item.getMap()) != null) {
                for (int i = 0; i < maps.getRuleCount(); ++i) {
                    maps.getRule(i).setConditionExpr((String)newExpressions.get(expressionIndex++));
                }
            }
            if ((visibilities = item.getVisibility()) != null) {
                for (int i = 0; i < visibilities.count(); ++i) {
                    visibilities.getRule(i).setExpression((String)newExpressions.get(expressionIndex++));
                }
            }
            if ((namedExpressions = item.getNamedExpressions()) != null) {
                Set exprs = namedExpressions.entrySet();
                Iterator exprIter = exprs.iterator();
                Map.Entry entry = null;
                while (exprIter.hasNext()) {
                    entry = (Map.Entry)exprIter.next();
                    entry.setValue((String)newExpressions.get(expressionIndex++));
                }
            }
            if ((action = item.getAction()) != null) {
                switch (action.getActionType()) {
                    case 2: {
                        action.setBookmark((String)newExpressions.get(expressionIndex++));
                        break;
                    }
                    case 3: {
                        DrillThroughActionDesign drillThrough = action.getDrillThrough();
                        if (drillThrough == null) break;
                        drillThrough.setBookmark((String)newExpressions.get(expressionIndex++));
                        if (drillThrough.getParameters() == null) break;
                        Iterator ite = drillThrough.getParameters().entrySet().iterator();
                        while (ite.hasNext()) {
                            Map.Entry entry = ite.next();
                            if (!$assertionsDisabled && !(entry.getValue() instanceof String)) {
                                throw new AssertionError();
                            }
                            entry.setValue((String)newExpressions.get(expressionIndex++));
                        }
                        break;
                    }
                    case 1: {
                        action.setHyperlink((String)newExpressions.get(expressionIndex++));
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
        }

        private ITotalExprBindings getNewExpressionBindings(ReportItemDesign item) {
            ActionDesign action;
            Map namedExpressions;
            VisibilityDesign visibilities;
            MapDesign maps;
            ArrayList<String> expressions = new ArrayList<String>();
            expressions.add(item.getTOC());
            expressions.add(item.getBookmark());
            expressions.add(item.getOnCreate());
            expressions.add(item.getOnRender());
            expressions.add(item.getOnPageBreak());
            HighlightDesign highlights = item.getHighlight();
            if (highlights != null) {
                for (int i = 0; i < highlights.getRuleCount(); ++i) {
                    expressions.add((String)this.createConditionalExpression(highlights.getRule(i)));
                }
            }
            if ((maps = item.getMap()) != null) {
                for (int i = 0; i < maps.getRuleCount(); ++i) {
                    expressions.add((String)this.createConditionalExpression(maps.getRule(i)));
                }
            }
            if ((visibilities = item.getVisibility()) != null) {
                for (int i = 0; i < visibilities.count(); ++i) {
                    expressions.add(visibilities.getRule(i).getExpression());
                }
            }
            if ((namedExpressions = item.getNamedExpressions()) != null) {
                Set exprs = namedExpressions.entrySet();
                Iterator exprIter = exprs.iterator();
                Map.Entry entry = null;
                while (exprIter.hasNext()) {
                    entry = (Map.Entry)exprIter.next();
                    expressions.add((String)entry.getValue());
                }
            }
            if ((action = item.getAction()) != null) {
                switch (action.getActionType()) {
                    case 2: {
                        expressions.add(action.getBookmark());
                        break;
                    }
                    case 3: {
                        DrillThroughActionDesign drillThrough = action.getDrillThrough();
                        if (drillThrough == null) break;
                        expressions.add(drillThrough.getBookmark());
                        if (drillThrough.getParameters() == null) break;
                        Iterator ite = drillThrough.getParameters().entrySet().iterator();
                        while (ite.hasNext()) {
                            Map.Entry entry = ite.next();
                            if (!$assertionsDisabled && !(entry.getValue() instanceof String)) {
                                throw new AssertionError();
                            }
                            expressions.add((String)entry.getValue());
                        }
                        break;
                    }
                    case 1: {
                        expressions.add(action.getHyperlink());
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
            ITotalExprBindings totalExpressionBindings = ReportQueryBuilder.this.expressionUtil.prepareTotalExpressions(expressions, this.getCurrentGroupName());
            return totalExpressionBindings;
        }

        private void addNewColumnBindings(IBaseQueryDefinition query, ITotalExprBindings totalExpressionBindings) {
            IColumnBinding[] bindings = totalExpressionBindings.getColumnBindings();
            if (bindings != null) {
                for (int i = 0; i < bindings.length; ++i) {
                    this.addColumnBinding(query, bindings[i]);
                }
            }
        }

        private void addColumnBinding(IBaseQueryDefinition transfer, IColumnBinding binding) {
            if (!$assertionsDisabled && transfer == null) {
                throw new AssertionError();
            }
            transfer.getResultSetExpressions().put(binding.getResultSetColumnName(), binding.getBoundExpression());
        }

        private IConditionalExpression createConditionalExpression(RuleDesign rule) {
            ConditionalExpression expression = new ConditionalExpression(rule.getTestExpression(), ReportQueryBuilder.this.toDteFilterOperator(rule.getOperator()), rule.getValue1(), rule.getValue2());
            return ExpressionUtil.transformConditionalExpression((IConditionalExpression)expression);
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$engine$data$dte$ReportQueryBuilder == null ? (class$org$eclipse$birt$report$engine$data$dte$ReportQueryBuilder = ReportQueryBuilder.class$("org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder")) : class$org$eclipse$birt$report$engine$data$dte$ReportQueryBuilder).desiredAssertionStatus();
        }
    }
}

