/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.CellScriptExecutor;

public class CellExecutor
extends QueryItemExecutor {
    int cellId;
    boolean startOfGroup;
    private int currentItem = 0;

    protected CellExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        CellDesign cellDesign = (CellDesign)this.getDesign();
        ICellContent cellContent = this.report.createCellContent();
        this.setContent(cellContent);
        this.executeQuery();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(cellDesign, cellContent);
        cellContent.setColumn(cellDesign.getColumn());
        cellContent.setColSpan(cellDesign.getColSpan());
        cellContent.setRowSpan(cellDesign.getRowSpan());
        this.processAction(cellDesign, cellContent);
        this.processBookmark(cellDesign, cellContent);
        this.processStyle(cellDesign, cellContent);
        this.processVisibility(cellDesign, cellContent);
        cellContent.setStartOfGroup(this.startOfGroup);
        if (this.context.isInFactory()) {
            CellScriptExecutor.handleOnCreate(cellContent, this.context, true);
        }
        this.startTOCEntry(cellContent);
        if (this.emitter != null) {
            this.emitter.startCell(cellContent);
        }
        this.currentItem = 0;
        return this.content;
    }

    public void close() {
        ICellContent cellContent = (ICellContent)this.getContent();
        if (this.emitter != null) {
            this.emitter.endCell(cellContent);
        }
        this.context.unregisterOnPageBreak(this.content);
        this.finishTOCEntry();
        this.closeQuery();
        this.manager.releaseExecutor(14, this);
    }

    public boolean hasNextChild() {
        CellDesign cellDesign = (CellDesign)this.getDesign();
        return this.currentItem < cellDesign.getContentCount();
    }

    public IReportItemExecutor getNextChild() {
        CellDesign cellDesign = (CellDesign)this.getDesign();
        if (this.currentItem < cellDesign.getContentCount()) {
            ReportItemDesign itemDesign = cellDesign.getContent(this.currentItem++);
            ReportItemExecutor executor = this.manager.createExecutor(this, itemDesign);
            return executor;
        }
        return null;
    }

    public void setStartOfGroup(boolean startOfGroup) {
        this.startOfGroup = startOfGroup;
    }
}

