/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public abstract class QueryItemExecutor
extends StyledItemExecutor {
    protected boolean rsetEmpty;

    protected QueryItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    protected void closeQuery() {
        if (this.rset != null) {
            this.rset.close();
        }
    }

    protected void executeQuery() {
        this.rset = null;
        IBaseQueryDefinition query = this.design.getQuery();
        IResultSet parentRset = this.getParentResultSet();
        this.context.setResultSet(parentRset);
        if (query != null) {
            try {
                this.rset = this.context.executeQuery(parentRset, query);
                if (this.rset != null) {
                    this.rsetEmpty = !this.rset.next();
                    return;
                }
            }
            catch (BirtException ex) {
                this.context.addException(ex);
            }
        }
    }

    protected void accessQuery(ReportItemDesign design, IContentEmitter emitter) {
    }

    public DataID getDataID() {
        IResultSet curRset = this.getResultSet();
        if (curRset == null) {
            curRset = this.getParentResultSet();
        }
        if (curRset != null) {
            return new DataID(curRset.getID(), curRset.getCurrentPosition());
        }
        return null;
    }

    public void reset() {
        this.rset = null;
        this.rsetEmpty = false;
        super.reset();
    }
}

