/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.RowExecutor;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.executor.TableItemExecutor;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;

public class TableBandExecutor
extends StyledItemExecutor {
    int currentRow;
    TableItemExecutor tableExecutor;

    protected TableBandExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        ITableBandContent bandContent = this.report.createTableBandContent();
        this.setContent(bandContent);
        this.restoreResultSet();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(bandDesign, bandContent);
        this.startTOCEntry(bandContent);
        if (this.emitter != null) {
            this.emitter.startTableBand(bandContent);
        }
        this.currentRow = 0;
        return this.content;
    }

    public void close() {
        ITableBandContent bandContent = (ITableBandContent)this.getContent();
        if (this.emitter != null) {
            this.emitter.endTableBand(bandContent);
        }
        this.context.unregisterOnPageBreak(this.content);
        this.finishTOCEntry();
        this.manager.releaseExecutor(12, this);
    }

    public boolean hasNextChild() {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        return this.currentRow < bandDesign.getRowCount();
    }

    public IReportItemExecutor getNextChild() {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        if (this.currentRow < bandDesign.getRowCount()) {
            RowDesign rowDesign = bandDesign.getRow(this.currentRow++);
            RowExecutor rowExecutor = (RowExecutor)this.manager.createExecutor(this, rowDesign);
            rowExecutor.setRowId(this.tableExecutor.rowId++);
            if (bandDesign.getBandType() == 3 && this.currentRow == 1) {
                rowExecutor.startOfGroup = true;
            }
            return rowExecutor;
        }
        return null;
    }

    void setTableExecutor(TableItemExecutor tableExecutor) {
        this.tableExecutor = tableExecutor;
    }
}

