/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.script.internal.TextItemScriptExecutor;

public class TextItemExecutor
extends QueryItemExecutor {
    public TextItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        TextItemDesign textDesign = (TextItemDesign)this.getDesign();
        String contentType = ForeignContent.getTextRawType(textDesign.getTextType(), textDesign.getText());
        if ("text/html".equals(contentType)) {
            return this.executeHtmlText(this.emitter);
        }
        return this.executePlainText(this.emitter);
    }

    public void close() {
        this.context.unregisterOnPageBreak(this.content);
        this.finishTOCEntry();
        this.closeQuery();
        this.manager.releaseExecutor(6, this);
    }

    protected IContent executeHtmlText(IContentEmitter emitter) {
        TextItemDesign textDesign = (TextItemDesign)this.getDesign();
        IForeignContent textContent = this.report.createForeignContent();
        this.setContent(textContent);
        this.executeQuery();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(textDesign, textContent);
        this.processAction(textDesign, textContent);
        this.processBookmark(textDesign, textContent);
        this.processStyle(textDesign, textContent);
        this.processVisibility(textDesign, textContent);
        HashMap exprs = textDesign.getExpressions();
        if (exprs != null && !exprs.isEmpty()) {
            HashMap results = new HashMap();
            Iterator iter = exprs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String expr = (String)entry.getValue();
                Object value = this.evaluate(expr);
                results.put(entry.getKey(), value);
            }
            textContent.setRawValue(results);
        }
        textContent.setRawType("text/template");
        if (this.context.isInFactory()) {
            TextItemScriptExecutor.handleOnCreate(textContent, this.context);
        }
        this.startTOCEntry(this.content);
        if (emitter != null) {
            emitter.startForeign(textContent);
        }
        return textContent;
    }

    protected IContent executePlainText(IContentEmitter emitter) {
        TextItemDesign textDesign = (TextItemDesign)this.getDesign();
        ILabelContent textContent = this.report.createLabelContent();
        this.setContent(textContent);
        this.executeQuery();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(textDesign, textContent);
        textContent.setLabelText(textDesign.getText());
        textContent.setLabelKey(textDesign.getTextKey());
        this.processAction(textDesign, textContent);
        this.processBookmark(textDesign, textContent);
        this.processStyle(textDesign, textContent);
        this.processVisibility(textDesign, textContent);
        if (this.context.isInFactory()) {
            TextItemScriptExecutor.handleOnCreate(textContent, this.context);
        }
        this.startTOCEntry(this.content);
        if (emitter != null) {
            emitter.startLabel(textContent);
        }
        return textContent;
    }
}

