/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v1;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.v1.PageHintV1;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class PageHintReaderV1
implements IPageHintReader {
    private static Logger logger = Logger.getLogger(ReportDocumentReader.class.getName());
    protected IReportDocument document;
    ArrayList pageHints = new ArrayList();

    public PageHintReaderV1(IReportDocument document) {
        this.document = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void open() throws IOException {
        block13: {
            RAInputStream in = null;
            IDocArchiveReader reader = this.document.getArchive();
            in = reader.getStream("/pages");
            if (in != null) {
                DataInputStream di = new DataInputStream(new BufferedInputStream((InputStream)in));
                long pageCount = IOUtil.readLong((DataInputStream)di);
                for (long i = 0L; i < pageCount; ++i) {
                    PageHintV1 hint = new PageHintV1();
                    hint.readObject(di);
                    this.pageHints.add(hint);
                }
            }
            Object var10_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block13;
            }
            catch (Exception ex2) {}
            break block13;
            {
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Failed to load the page hints", ex);
                    Object var10_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block13;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void close() {
    }

    public long getTotalPage() {
        return this.pageHints.size();
    }

    public IPageHint getPageHint(long pageNumber) {
        return (PageHintV1)this.pageHints.get((int)pageNumber);
    }

    public long findPage(long offset) {
        for (int i = 0; i < this.pageHints.size(); ++i) {
            PageHintV1 hint = (PageHintV1)this.pageHints.get(i);
            if (hint.getSectionStart(0) <= offset) continue;
            return i + 1;
        }
        return this.pageHints.size();
    }
}

