/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v1;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.content.ContentFactory;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.document.IReportContentLoader;
import org.eclipse.birt.report.engine.internal.document.v1.PageHintReaderV1;
import org.eclipse.birt.report.engine.internal.document.v1.ReportContentReaderV1;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportContentLoaderV1
implements IReportContentLoader {
    protected static Logger logger;
    protected ExecutionContext context;
    protected IDataEngine dataEngine;
    protected IContentEmitter emitter;
    protected ReportContentReaderV1 reader;
    protected ReportContentReaderV1 pageReader;
    protected PageHintReaderV1 hintReader;
    protected Report report;
    protected IReportDocument reportDoc;
    protected ReportContent reportContent;
    protected long currentOffset;
    protected Stack resultSets = new Stack();
    private HashMap generateByIDs;
    protected IContentVisitor outputStartVisitor = new IContentVisitor(){

        public Object visit(IContent content, Object value) {
            return content.accept(this, value);
        }

        public Object visitContent(IContent content, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startContent(content);
            return value;
        }

        public Object visitPage(IPageContent page, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startPage(page);
            return value;
        }

        public Object visitContainer(IContainerContent container, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startContainer(container);
            return value;
        }

        public Object visitTable(ITableContent table, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTable(table);
            return value;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            ReportContentLoaderV1.this.emitter.startTableBand(tableBand);
            return value;
        }

        public Object visitRow(IRowContent row, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startRow(row);
            return value;
        }

        public Object visitCell(ICellContent cell, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startCell(cell);
            return value;
        }

        public Object visitText(ITextContent text, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startText(text);
            return value;
        }

        public Object visitLabel(ILabelContent label, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startLabel(label);
            return value;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            if (autoText.getType() == 0) {
                autoText.setText(String.valueOf(ReportContentLoaderV1.this.reportDoc.getPageCount()));
            }
            emitter.startAutoText(autoText);
            return value;
        }

        public Object visitData(IDataContent data, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startData(data);
            return value;
        }

        public Object visitImage(IImageContent image, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startImage(image);
            return value;
        }

        public Object visitForeign(IForeignContent content, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startForeign(content);
            return value;
        }

        public Object visitList(IListContent list, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startList(list);
            return value;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startListBand(listBand);
            return value;
        }

        public Object visitGroup(IGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startGroup(group);
            return value;
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startListGroup(group);
            return value;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTableGroup(group);
            return value;
        }
    };
    protected IContentVisitor outputEndVisitor = new IContentVisitor(){

        public Object visit(IContent content, Object value) {
            return content.accept(this, value);
        }

        public Object visitContent(IContent content, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endContent(content);
            return value;
        }

        public Object visitPage(IPageContent page, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endPage(page);
            return value;
        }

        public Object visitContainer(IContainerContent container, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endContainer(container);
            return value;
        }

        public Object visitTable(ITableContent table, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTable(table);
            return value;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTableBand(tableBand);
            return value;
        }

        public Object visitRow(IRowContent row, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endRow(row);
            return value;
        }

        public Object visitCell(ICellContent cell, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endCell(cell);
            return value;
        }

        public Object visitText(ITextContent text, Object value) {
            return value;
        }

        public Object visitLabel(ILabelContent label, Object value) {
            return value;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            return value;
        }

        public Object visitData(IDataContent data, Object value) {
            return value;
        }

        public Object visitImage(IImageContent image, Object value) {
            return value;
        }

        public Object visitForeign(IForeignContent content, Object value) {
            return value;
        }

        public Object visitList(IListContent list, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endList(list);
            return value;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endListBand(listBand);
            return value;
        }

        public Object visitGroup(IGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endGroup(group);
            return value;
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endListGroup(group);
            return value;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTableGroup(group);
            return value;
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportContentLoaderV1(ExecutionContext context) {
        this.context = context;
        this.dataEngine = context.getDataEngine();
        ReportDesignHandle reportDesign = context.getDesign();
        Report report = new ReportParser(context).parse(reportDesign);
        context.setReport(report);
        this.reportContent = (ReportContent)ContentFactory.createReportContent(report);
        context.setReportContent(this.reportContent);
        this.reportDoc = (ReportDocumentReader)context.getReportDocument();
        this.dataEngine.prepare(report, context.getAppContext());
    }

    protected void openReaders() {
        try {
            this.reader = new ReportContentReaderV1(this.reportContent, this.reportDoc);
            this.reader.open("/content/content.dat");
            this.pageReader = new ReportContentReaderV1(this.reportContent, this.reportDoc);
            this.pageReader.open("/content/page.dat");
            this.hintReader = new PageHintReaderV1(this.reportDoc);
            this.hintReader.open();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to open the content reader", ex);
            this.closeReaders();
        }
    }

    protected void closeReaders() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.pageReader != null) {
            this.pageReader.close();
            this.pageReader = null;
        }
        if (this.hintReader != null) {
            this.hintReader.close();
            this.hintReader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPage(long pageNumber, boolean bodyOnly, IContentEmitter emitter) {
        emitter.start(this.reportContent);
        this.emitter = emitter;
        try {
            this.openReaders();
            this.excutePage(pageNumber, bodyOnly);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to load the page", ex);
            ex.printStackTrace();
        }
        finally {
            emitter.end(this.reportContent);
            this.closeReaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadReportlet(long offset, IContentEmitter emitter) {
        emitter.start(this.reportContent);
        this.emitter = emitter;
        try {
            this.openReaders();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to load the page", ex);
            ex.printStackTrace();
        }
        finally {
            emitter.end(this.reportContent);
            this.closeReaders();
        }
    }

    private void excutePage(long pageNumber, boolean bodyOnly) {
        IPageHint pageHint = this.hintReader.getPageHint(pageNumber);
        IPageContent pageContent = null;
        if (!bodyOnly) {
            pageContent = this.loadPageContent(pageHint.getOffset());
            if (pageContent == null) {
                return;
            }
            Object generateBy = pageContent.getGenerateBy();
            if (generateBy instanceof SimpleMasterPageDesign) {
                SimpleMasterPageDesign pageDesign = (SimpleMasterPageDesign)generateBy;
                if (!pageDesign.isShowHeaderOnFirst() && pageNumber == 1L) {
                    pageContent.getHeader().clear();
                }
                if (!pageDesign.isShowFooterOnLast() && pageNumber == this.reportDoc.getPageCount()) {
                    pageContent.getFooter().clear();
                }
            }
            this.emitter.startPage(pageContent);
        }
        long startOffset = pageHint.getSectionStart(0);
        long endOffset = pageHint.getSectionEnd(0);
        if (startOffset != -1L && endOffset != -1L && this.reader != null) {
            this.reader.setOffset(startOffset);
            IContent content = this.loadContent(this.reader);
            while (content != null && this.currentOffset <= endOffset) {
                content = this.loadFullContent(content, this.reader, this.emitter);
            }
        }
        if (!bodyOnly) {
            this.emitter.endPage(pageContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPageRange(List pageList, boolean bodyOnly, IContentEmitter emitter) {
        emitter.start(this.reportContent);
        this.emitter = emitter;
        try {
            this.openReaders();
            for (int m = 0; m < pageList.size(); ++m) {
                long[] ps = (long[])pageList.get(m);
                for (long i = ps[0]; i <= ps[1]; ++i) {
                    this.excutePage(i, bodyOnly);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to load the page", ex);
            ex.printStackTrace();
        }
        finally {
            emitter.end(this.reportContent);
            this.closeReaders();
        }
    }

    protected IPageContent loadPageContent(long offset) {
        if (this.pageReader != null) {
            int i;
            this.pageReader.setOffset(offset);
            IPageContent pageContent = (IPageContent)this.loadContent(this.pageReader);
            if (pageContent == null) {
                return null;
            }
            SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)pageContent.getGenerateBy();
            IContent content = this.loadContent(this.pageReader);
            for (i = 0; i < masterPage.getHeaderCount(); ++i) {
                pageContent.getHeader().add(content);
                content = this.loadFullContent(content, this.pageReader, new DOMBuildingEmitter());
            }
            for (i = 0; i < masterPage.getFooterCount(); ++i) {
                pageContent.getFooter().add(content);
                content = this.loadFullContent(content, this.pageReader, new DOMBuildingEmitter());
            }
            return pageContent;
        }
        return null;
    }

    protected IContent loadFullContent(IContent root, ReportContentReaderV1 reader, IContentEmitter emitter) {
        Stack<IContent> contents = new Stack<IContent>();
        contents.push(root);
        this.startContent(root, emitter);
        IContent next = this.loadContent(reader);
        do {
            IContent parent;
            if (this.isChildOf(next, parent = (IContent)contents.peek())) {
                contents.push(next);
                next.setParent(parent);
                this.startContent(next, emitter);
                next = this.loadContent(reader);
                continue;
            }
            this.endContent(parent, emitter);
            contents.pop();
        } while (!contents.isEmpty());
        return next;
    }

    private boolean isChildOf(DesignElementHandle child, DesignElementHandle parent) {
        DesignElementHandle container = child.getContainer();
        if (container == parent) {
            return true;
        }
        if (container == null) {
            return false;
        }
        return this.isChildOf(container, parent);
    }

    private boolean isChildOf(IContent content, IContent parent) {
        if (content != null && parent != null) {
            DesignElementHandle handle = this.getDesignHandle(content);
            DesignElementHandle parentHandle = this.getDesignHandle(parent);
            if (handle != null && parentHandle != null) {
                return this.isChildOf(handle, parentHandle);
            }
            if (parent instanceof ITableContent && content instanceof ITableBandContent) {
                return true;
            }
            if (parent instanceof ITableBandContent && content instanceof IRowContent) {
                return this.isRowInBand((IRowContent)content, (ITableBandContent)parent);
            }
            if (parent instanceof IRowContent && content instanceof ICellContent) {
                return true;
            }
        }
        return false;
    }

    private boolean isRowInBand(IRowContent row, ITableBandContent band) {
        Object generateBy = row.getGenerateBy();
        if (generateBy instanceof RowDesign) {
            ITableContent table;
            RowDesign rowDesign = (RowDesign)generateBy;
            IElement parent = band.getParent();
            if (parent instanceof ITableContent && (generateBy = (table = (ITableContent)parent).getGenerateBy()) instanceof ReportItemDesign) {
                DesignElementHandle rowHandle = rowDesign.getHandle();
                DesignElementHandle tableHandle = ((ReportItemDesign)generateBy).getHandle();
                if (rowHandle.getContainer() == tableHandle || rowHandle.getContainer().getContainer() == tableHandle) {
                    return true;
                }
            }
        }
        return false;
    }

    protected IContent loadContent(ReportContentReaderV1 reader) {
        if (reader != null) {
            try {
                this.currentOffset = reader.getOffset();
                IContent content = reader.readContent();
                this.initializeContent(content);
                return content;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "load content failed", ex);
            }
        }
        return null;
    }

    protected void initializeContent(IContent content) {
        long designId;
        content.setReportContent(this.reportContent);
        InstanceID id = content.getInstanceID();
        if (id != null && (designId = id.getComponentID()) != -1L) {
            Object generateBy = this.findReportItem(designId);
            content.setGenerateBy(generateBy);
            if (generateBy instanceof TemplateDesign) {
                TemplateDesign design = (TemplateDesign)generateBy;
                if (content instanceof ILabelContent) {
                    ILabelContent labelContent = (ILabelContent)content;
                    labelContent.setLabelKey(design.getPromptTextKey());
                    labelContent.setLabelText(design.getPromptText());
                }
            }
        }
    }

    private DesignElementHandle getDesignHandle(IContent content) {
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ReportElementDesign) {
            return ((ReportElementDesign)generateBy).getHandle();
        }
        return null;
    }

    protected Object findReportItem(long designId) {
        if (this.generateByIDs == null) {
            this.generateByIDs = new HashMap();
            new GenerateIDMapVisitor(this.generateByIDs).visitReport(this.report);
        }
        return this.generateByIDs.get(new Long(designId));
    }

    protected void openQuery(IContent content) {
        InstanceID iid;
        IResultSet rset;
        ReportItemDesign design;
        IBaseQueryDefinition query;
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ReportItemDesign && !(generateBy instanceof ExtendedItemDesign) && (query = (design = (ReportItemDesign)generateBy).getQuery()) != null) {
            rset = this.dataEngine.execute(query);
            this.resultSets.push(rset);
        }
        if ((iid = content.getInstanceID()) != null) {
            long rowId;
            DataID dataId = iid.getDataID();
            while (dataId == null && iid.getParentID() != null) {
                iid = iid.getParentID();
                dataId = iid.getDataID();
            }
            if (dataId != null && !this.resultSets.isEmpty() && (rset = (IResultSet)this.resultSets.peek()) != null && (rowId = dataId.getRowID()) != -1L && rowId != rset.getCurrentPosition()) {
                rset.skipTo(rowId);
            }
        }
        if (generateBy instanceof DataItemDesign && content instanceof DataContent) {
            String valueExpr;
            DataItemDesign design2 = (DataItemDesign)generateBy;
            DataContent data = (DataContent)content;
            if (design2.getMap() == null && (valueExpr = design2.getValue()) != null) {
                Object value = this.context.evaluate(valueExpr);
                data.setValue(value);
            }
        }
    }

    protected void checkDataSet(DataID dataId, IResultSet rset) {
        DataSetID dsetId = rset.getID();
        DataSetID rsetId = dataId.getDataSetID();
        if (!$assertionsDisabled && dsetId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsetId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !dsetId.toString().equals(rsetId.toString())) {
            throw new AssertionError();
        }
    }

    protected void closeQuery(IContent content) {
        IResultSet rset;
        ReportItemDesign design;
        IBaseQueryDefinition query;
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ReportItemDesign && !(generateBy instanceof ExtendedItemDesign) && (query = (design = (ReportItemDesign)generateBy).getQuery()) != null && (rset = (IResultSet)this.resultSets.pop()) != null) {
            rset.close();
        }
    }

    protected void startContent(IContent content, IContentEmitter emitter) {
        this.openQuery(content);
        this.outputStartVisitor.visit(content, emitter);
    }

    protected void endContent(IContent content, IContentEmitter emitter) {
        this.outputEndVisitor.visit(content, emitter);
        this.closeQuery(content);
    }

    static {
        $assertionsDisabled = !ReportContentLoaderV1.class.desiredAssertionStatus();
        logger = Logger.getLogger(ReportContentLoaderV1.class.getName());
    }

    protected class GenerateIDMapVisitor
    extends DefaultReportItemVisitorImpl {
        private HashMap IDMaps;

        public GenerateIDMapVisitor(HashMap map) {
            this.IDMaps = map;
        }

        public void visitReport(Report report) {
            int i;
            PageSetupDesign pageSetup = report.getPageSetup();
            for (i = 0; i < pageSetup.getMasterPageCount(); ++i) {
                int j;
                MasterPageDesign masterPage = pageSetup.getMasterPage(i);
                this.IDMaps.put(new Long(masterPage.getID()), masterPage);
                if (!(masterPage instanceof SimpleMasterPageDesign)) continue;
                SimpleMasterPageDesign simpleMasterPage = (SimpleMasterPageDesign)masterPage;
                for (j = 0; j < simpleMasterPage.getHeaderCount(); ++j) {
                    simpleMasterPage.getHeader(j).accept(this, null);
                }
                for (j = 0; j < simpleMasterPage.getFooterCount(); ++j) {
                    simpleMasterPage.getFooter(j).accept(this, null);
                }
            }
            for (i = 0; i < report.getContentCount(); ++i) {
                report.getContent(i).accept(this, null);
            }
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            this.IDMaps.put(new Long(container.getID()), container);
            for (int i = 0; i < container.getItemCount(); ++i) {
                container.getItem(i).accept(this, value);
            }
            return value;
        }

        public Object visitListingItem(ListItemDesign list, Object value) {
            this.IDMaps.put(new Long(list.getID()), list);
            if (list.getHeader() != null) {
                list.getHeader().accept(this, value);
            }
            for (int i = 0; i < list.getGroupCount(); ++i) {
                list.getGroup(i).accept(this, value);
            }
            if (list.getDetail() != null) {
                list.getDetail().accept(this, value);
            }
            if (list.getFooter() != null) {
                list.getFooter().accept(this, value);
            }
            return value;
        }

        public Object visitGroup(GroupDesign group, Object value) {
            this.IDMaps.put(new Long(group.getID()), group);
            if (group.getHeader() != null) {
                group.getHeader().accept(this, value);
            }
            if (group.getFooter() != null) {
                group.getFooter().accept(this, value);
            }
            return value;
        }

        public Object visitBand(BandDesign band, Object value) {
            if (band != null) {
                this.IDMaps.put(new Long(band.getID()), band);
                for (int i = 0; i < band.getContentCount(); ++i) {
                    band.getContent(i).accept(this, null);
                }
            }
            return value;
        }

        public Object visitReportItem(ReportItemDesign item, Object value) {
            this.IDMaps.put(new Long(item.getID()), item);
            return value;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            this.IDMaps.put(new Long(grid.getID()), grid);
            for (int i = 0; i < grid.getRowCount(); ++i) {
                grid.getRow(i).accept(this, value);
            }
            return value;
        }

        public Object visitRow(RowDesign row, Object value) {
            this.visitReportItem(row, value);
            for (int i = 0; i < row.getCellCount(); ++i) {
                row.getCell(i).accept(this, value);
            }
            return value;
        }

        public Object visitCell(CellDesign cell, Object value) {
            this.visitReportItem(cell, value);
            for (int i = 0; i < cell.getContentCount(); ++i) {
                cell.getContent(i).accept(this, value);
            }
            return value;
        }
    }

    private class DOMBuildingEmitter
    extends ContentEmitterAdapter {
        private IContent parent;

        public void startContent(IContent content) {
            if (this.parent != null) {
                this.parent.getChildren().add(content);
            }
            this.parent = content;
        }

        public void endContent(IContent content) {
            if (this.parent != null) {
                this.parent = (IContent)this.parent.getParent();
            }
        }
    }
}

