/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v3;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v3.ReportContentReaderV3;

public class CachedReportContentReaderV3 {
    protected ReportContentReaderV3 reader;
    protected LinkedList caches = new LinkedList();

    public CachedReportContentReaderV3(ReportContent reportContent, RAInputStream stream) {
        this.reader = new ReportContentReaderV3(reportContent, stream);
    }

    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.caches.clear();
            this.reader = null;
        }
    }

    protected void addCache(long offset, IContent content) {
        this.caches.add(new CacheEntry(offset, content));
    }

    protected void removeCache(long offset) {
        Iterator iter = this.caches.iterator();
        while (iter.hasNext()) {
            CacheEntry cache = (CacheEntry)iter.next();
            if (cache.offset != offset) continue;
            iter.remove();
            break;
        }
    }

    protected IContent findCache(long offset) {
        Iterator iter = this.caches.iterator();
        while (iter.hasNext()) {
            CacheEntry cache = (CacheEntry)iter.next();
            if (cache.offset != offset) continue;
            return cache.content;
        }
        return null;
    }

    public void unloadContent(long offset) {
        this.removeCache(offset);
    }

    public IContent loadContent(long offset) throws IOException {
        IContent content = this.findCache(offset);
        if (content != null) {
            return content;
        }
        content = this.reader.readContent(offset);
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        long pOffset = docExt.getParent();
        if (pOffset != -1L) {
            IContent parent = this.loadContent(pOffset);
            content.setParent(parent);
        }
        this.addCache(offset, content);
        return content;
    }

    protected class CacheEntry {
        long offset;
        IContent content;

        public CacheEntry(long offset, IContent content) {
            this.offset = offset;
            this.content = content;
        }
    }
}

