/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSStyleDeclaration;

public class Report {
    protected StyleDeclaration defaultStyle;
    protected String rootStyleName;
    protected ArrayList allParameters = null;
    protected ReportDesignHandle reportDesign;
    protected String unit;
    protected ArrayList styles = new ArrayList();
    protected HashMap styleTable = new HashMap();
    protected ArrayList parameters = new ArrayList();
    protected ArrayList queries = new ArrayList();
    protected HashMap queryIDs = new HashMap();
    protected HashMap resultMetaData = new HashMap();
    protected PageSetupDesign pageSetup = new PageSetupDesign();
    protected ArrayList contents = new ArrayList();
    protected Map namedExpressions;
    protected Map mapReportItemIDtoInstance;
    protected String basePath;
    public static final String PREFIX_STYLE_NAME = "style_";
    protected HashMap mapReportItemToQuery;
    protected HashMap mapQueryToValueExprs;
    protected HashMap mapValueExprToName;
    protected CSSEngine cssEngine = new BIRTCSSEngine();
    static final /* synthetic */ boolean $assertionsDisabled;

    public CSSEngine getCSSEngine() {
        return this.cssEngine;
    }

    public HashMap getReportItemToQueryMap() {
        if (this.mapReportItemToQuery == null) {
            this.mapReportItemToQuery = new HashMap();
        }
        return this.mapReportItemToQuery;
    }

    public HashMap getQueryToValueExprMap() {
        if (this.mapQueryToValueExprs == null) {
            this.mapQueryToValueExprs = new HashMap();
        }
        return this.mapQueryToValueExprs;
    }

    public HashMap getExprToNameMap() {
        if (this.mapValueExprToName == null) {
            this.mapValueExprToName = new HashMap();
        }
        return this.mapQueryToValueExprs;
    }

    public void setReportItemInstanceID(long id, ReportElementDesign rptElement) {
        if (this.mapReportItemIDtoInstance == null) {
            this.mapReportItemIDtoInstance = new HashMap();
        }
        this.mapReportItemIDtoInstance.put(new Long(id), rptElement);
    }

    public ReportElementDesign getReportItemByID(long id) {
        if (!$assertionsDisabled && this.mapReportItemIDtoInstance == null) {
            throw new AssertionError();
        }
        return (ReportElementDesign)this.mapReportItemIDtoInstance.get(new Long(id));
    }

    public Map getNamedExpressions() {
        if (this.namedExpressions == null) {
            this.namedExpressions = new HashMap();
        }
        return this.namedExpressions;
    }

    public void setPageSetup(PageSetupDesign pageSetup) {
        this.pageSetup = pageSetup;
    }

    public PageSetupDesign getPageSetup() {
        return this.pageSetup;
    }

    public ArrayList getContents() {
        return this.contents;
    }

    public int getContentCount() {
        return this.contents.size();
    }

    public ReportItemDesign getContent(int index) {
        if (!($assertionsDisabled || index >= 0 && index < this.contents.size())) {
            throw new AssertionError();
        }
        return (ReportItemDesign)this.contents.get(index);
    }

    public void addContent(ReportItemDesign item) {
        this.contents.add(item);
    }

    public int getStyleCount() {
        return this.styles.size();
    }

    public IStyle getStyle(int index) {
        if (!($assertionsDisabled || index >= 0 && index < this.styles.size())) {
            throw new AssertionError();
        }
        return (IStyle)this.styles.get(index);
    }

    public void addStyle(String name, CSSStyleDeclaration style) {
        if (!$assertionsDisabled && style == null) {
            throw new AssertionError();
        }
        this.styles.add(style);
        this.styleTable.put(name, style);
    }

    public Set getStyleSet() {
        return this.styleTable.entrySet();
    }

    public IStyle findStyle(String name) {
        if (name == null) {
            return null;
        }
        return (IStyle)this.styleTable.get(name);
    }

    public void addParameter(IParameterDefnBase parameter) {
        if (!$assertionsDisabled && parameter == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parameter.getName() == null) {
            throw new AssertionError();
        }
        this.parameters.add(parameter);
    }

    public MasterPageDesign findMasterPage(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.pageSetup.findMasterPage(name);
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getMessage(String resourceKey, Locale locale) {
        if (this.reportDesign != null) {
            return this.reportDesign.getMessage(resourceKey, locale);
        }
        return null;
    }

    public ReportDesignHandle getReportDesign() {
        return this.reportDesign;
    }

    public void setReportDesign(ReportDesignHandle reportDesign) {
        this.reportDesign = reportDesign;
        if (this.basePath == null || this.basePath.equals("")) {
            File file = new File(reportDesign.getFileName());
            this.basePath = file.getParent();
        }
    }

    public ArrayList getQueries() {
        return this.queries;
    }

    public HashMap getQueryIDs() {
        return this.queryIDs;
    }

    public HashMap getResultMetaData() {
        return this.resultMetaData;
    }

    protected void flattenParameter(ArrayList params) {
        if (!$assertionsDisabled && this.allParameters == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && params == null) {
            throw new AssertionError();
        }
        for (int n = 0; n < params.size(); ++n) {
            IParameterDefnBase param = (IParameterDefnBase)params.get(n);
            if (param.getParameterType() == 4) {
                this.flattenParameter(((IParameterGroupDefn)param).getContents());
                continue;
            }
            this.allParameters.add(param);
        }
    }

    public ArrayList getParameters(boolean includeParameterGroups) {
        if (includeParameterGroups) {
            return this.parameters;
        }
        if (this.allParameters != null) {
            return this.allParameters;
        }
        this.allParameters = new ArrayList();
        this.flattenParameter(this.parameters);
        return this.allParameters;
    }

    public HashMap getConfigs() {
        HashMap<String, String> configs = new HashMap<String, String>();
        Iterator iter = this.reportDesign.configVariablesIterator();
        if (iter != null) {
            while (iter.hasNext()) {
                ConfigVariableHandle handle = (ConfigVariableHandle)iter.next();
                String name = handle.getName();
                String value = handle.getValue();
                configs.put(name, value);
            }
        }
        return configs;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public StyleDeclaration getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(StyleDeclaration defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public String getRootStyleName() {
        return this.rootStyleName;
    }

    public void setRootStyleName(String rootStyleName) {
        this.rootStyleName = rootStyleName;
    }

    public List getErrors() {
        return this.reportDesign.getErrorList();
    }

    static {
        $assertionsDisabled = !Report.class.desiredAssertionStatus();
    }
}

