/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.area.impl;

import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.ITemplateArea;
import org.eclipse.birt.report.engine.layout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.ImageArea;
import org.eclipse.birt.report.engine.layout.area.impl.InlineContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.LineArea;
import org.eclipse.birt.report.engine.layout.area.impl.LogicContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.area.impl.TemplateArea;
import org.eclipse.birt.report.engine.layout.area.impl.TextArea;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class AreaFactory {
    public static IImageArea createImageArea(IImageContent image, Dimension contentDimension) {
        ImageArea imageArea = new ImageArea(image);
        imageArea.setWidth(contentDimension.getWidth());
        imageArea.setHeight(contentDimension.getHeight());
        return imageArea;
    }

    public static ITemplateArea createTemplateArea(IAutoTextContent autoText, Dimension contentDimension) {
        TemplateArea templateArea = new TemplateArea(autoText);
        templateArea.setWidth(contentDimension.getWidth());
        templateArea.setHeight(contentDimension.getHeight());
        return templateArea;
    }

    public static IArea createInlineTextArea(String text, ITextContent content, int startOffset, int endOffset, FontInfo fi, Dimension contentDimension) {
        IStyle style = content.getComputedStyle();
        ContainerArea con = (ContainerArea)AreaFactory.createInlineContainer(content, false, false);
        int textHeight = contentDimension.getHeight();
        int textWidth = contentDimension.getWidth();
        con.setWidth(textWidth);
        con.setHeight(textHeight + PropertyUtil.getDimensionValue(style.getProperty(56)) + PropertyUtil.getDimensionValue(style.getProperty(15)) + PropertyUtil.getDimensionValue(style.getProperty(55)) + PropertyUtil.getDimensionValue(style.getProperty(19)));
        TextArea textArea = new TextArea(content, text, fi);
        con.addChild(textArea);
        textArea.setHeight(textHeight);
        textArea.setWidth(textWidth);
        textArea.setPosition(0, PropertyUtil.getDimensionValue(style.getProperty(56)) + PropertyUtil.getDimensionValue(style.getProperty(15)));
        return con;
    }

    public static IArea createBlockTextArea(String text, ITextContent content, int startOffset, int endOffset, FontInfo fi, Dimension contentDimension) {
        TextArea textArea = new TextArea(content, text, fi);
        textArea.setWidth(contentDimension.getWidth());
        textArea.setHeight(contentDimension.getHeight());
        return textArea;
    }

    public static IContainerArea createInlineContainer(IContent content) {
        return AreaFactory.createInlineContainer(content, true, true);
    }

    public static IContainerArea createInlineContainer(IContent content, boolean isFirst, boolean isLast) {
        InlineContainerArea containerArea = new InlineContainerArea(content);
        IStyle style = containerArea.getStyle();
        if (!isFirst) {
            style.setProperty(17, IStyle.NUMBER_0);
            style.setProperty(36, IStyle.NUMBER_0);
            style.setProperty(31, IStyle.NUMBER_0);
        }
        if (!isLast) {
            style.setProperty(18, IStyle.NUMBER_0);
            style.setProperty(37, IStyle.NUMBER_0);
            style.setProperty(32, IStyle.NUMBER_0);
        }
        return containerArea;
    }

    public static IContainerArea createBlockContainer(IContent content) {
        return AreaFactory.createBlockContainer(content, true, true);
    }

    public static IContainerArea createBlockContainer(IContent content, boolean isFirst, boolean isLast) {
        BlockContainerArea containerArea = new BlockContainerArea(content);
        IStyle style = containerArea.getStyle();
        if (!isFirst) {
            style.setProperty(15, IStyle.NUMBER_0);
            style.setProperty(56, IStyle.NUMBER_0);
            style.setProperty(53, IStyle.NUMBER_0);
        }
        if (!isLast) {
            style.setProperty(19, IStyle.NUMBER_0);
            style.setProperty(55, IStyle.NUMBER_0);
            style.setProperty(52, IStyle.NUMBER_0);
        }
        return containerArea;
    }

    public static IContainerArea createBlockContainer(IContainerArea area, boolean isFirst, boolean isLast) {
        ContainerArea containerArea = (ContainerArea)area.copyArea();
        IStyle style = containerArea.getStyle();
        if (!isFirst) {
            style.setProperty(15, IStyle.NUMBER_0);
            style.setProperty(56, IStyle.NUMBER_0);
            style.setProperty(53, IStyle.NUMBER_0);
        }
        if (!isLast) {
            style.setProperty(19, IStyle.NUMBER_0);
            style.setProperty(55, IStyle.NUMBER_0);
            style.setProperty(52, IStyle.NUMBER_0);
        }
        return containerArea;
    }

    public static IContainerArea createLogicContainer() {
        LogicContainerArea con = new LogicContainerArea();
        return con;
    }

    public static CellArea createCellArea(ICellContent cell) {
        CellArea cellArea = new CellArea(cell);
        return cellArea;
    }

    public static IContainerArea createPageArea(IPageContent pageContent) {
        PageArea page = new PageArea(pageContent);
        return page;
    }

    public static TableArea createTableArea(ITableContent table) {
        TableArea tableArea = new TableArea(table);
        return tableArea;
    }

    public static RowArea createRowArea(IRowContent row) {
        RowArea rowArea = new RowArea(row);
        return rowArea;
    }

    public static LineArea createLineArea() {
        LineArea line = new LineArea();
        return line;
    }
}

