/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLStackingLM;

public abstract class HTMLInlineStackingLM
extends HTMLStackingLM {
    protected boolean initializedChildren = false;
    protected List childrenLayouts = new ArrayList();
    protected List childrenExecutors = new ArrayList();
    protected List childrenFinished = new ArrayList();

    public HTMLInlineStackingLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        super.initialize(parent, content, executor, emitter);
        this.initializedChildren = false;
    }

    public void close() {
        this.childrenLayouts.clear();
        this.childrenExecutors.clear();
        this.childrenFinished.clear();
        super.close();
    }

    private void initalizeChildren() {
        while (this.executor.hasNextChild()) {
            IReportItemExecutor childExecutor = this.executor.getNextChild();
            IContent childContent = childExecutor.execute();
            ILayoutManager childLayout = this.engine.createLayoutManager(this, childContent, childExecutor, this.emitter);
            this.childrenLayouts.add(childLayout);
            this.childrenExecutors.add(childExecutor);
            this.childrenFinished.add(Boolean.FALSE);
        }
    }

    protected boolean resumeLayout() {
        boolean hasNextPage = false;
        for (int i = 0; i < this.childrenLayouts.size(); ++i) {
            boolean childFinished = (Boolean)this.childrenFinished.get(i);
            if (!childFinished) {
                ILayoutManager childLayout = (ILayoutManager)this.childrenLayouts.get(i);
                boolean childHasNewPage = childLayout.layout();
                if (childHasNewPage) {
                    hasNextPage = true;
                }
                if (childFinished = childLayout.isFinished()) {
                    childLayout.close();
                    IReportItemExecutor childExecutor = (IReportItemExecutor)this.childrenExecutors.get(i);
                    childExecutor.close();
                }
                this.childrenFinished.set(i, childFinished);
                continue;
            }
            this.context.skipContent(null);
        }
        return hasNextPage;
    }

    protected boolean isChildrenFinished() {
        for (int i = 0; i < this.childrenLayouts.size(); ++i) {
            boolean childFinished = (Boolean)this.childrenFinished.get(i);
            if (childFinished) continue;
            return false;
        }
        return true;
    }

    protected boolean layoutChildren() {
        if (!this.initializedChildren) {
            this.initializedChildren = true;
            this.initalizeChildren();
        }
        return this.resumeLayout();
    }
}

