/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutEmitter;

public class HTMLTableLM
extends HTMLBlockStackingLM {
    protected HTMLTableLayoutEmitter tableEmitter;
    boolean isFirstLayout = true;

    public HTMLTableLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 3;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        this.tableEmitter = new HTMLTableLayoutEmitter(emitter);
        super.initialize(parent, content, executor, this.tableEmitter);
        this.isFirstLayout = true;
    }

    protected void repeatHeader() {
        ITableBandContent header;
        ITableContent table;
        if (!this.isFirstLayout && (table = (ITableContent)this.content).isHeaderRepeat() && (header = table.getHeader()) != null) {
            boolean pageBreak = this.context.allowPageBreak();
            boolean skipPageHint = this.context.getSkipPageHint();
            this.context.setAllowPageBreak(pageBreak);
            this.context.setSkipPageHint(true);
            this.engine.layout(header, this.emitter);
            this.context.setAllowPageBreak(pageBreak);
            this.context.setSkipPageHint(skipPageHint);
        }
        this.isFirstLayout = false;
    }

    protected boolean layoutChildren() {
        this.repeatHeader();
        boolean hasNext = super.layoutChildren();
        this.tableEmitter.resolveAll();
        this.tableEmitter.flush();
        return hasNext;
    }

    public void updateDropCells(int groupLevel, boolean dropAll) {
        this.tableEmitter.resolveCellsOfDrop(groupLevel, dropAll);
    }
}

