/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.IPDFTableLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFCellLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    protected IPDFTableLayoutManager tableLM;
    protected int columnWidth = 0;
    private ICellContent cellContent;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFCellLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IContentEmitter emitter, IReportItemExecutor executor) {
        super(context, parent, content, emitter, executor);
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        this.tableLM = this.getTableLayoutManager();
        this.cellContent = (ICellContent)content;
        this.tableLM.startCell(this.cellContent);
        int startColumn = this.cellContent.getColumn();
        int endColumn = startColumn + this.cellContent.getColSpan();
        this.columnWidth = this.tableLM.getCellWidth(startColumn, endColumn);
    }

    protected void createRoot() {
        this.root = AreaFactory.createCellArea(this.cellContent);
        this.tableLM.resolveBorderConflict((CellArea)this.root);
        this.root.setWidth(this.columnWidth);
        if (!this.isFirst) {
            IStyle areaStyle = this.root.getStyle();
            areaStyle.setProperty(15, IStyle.NUMBER_0);
            areaStyle.setProperty(56, IStyle.NUMBER_0);
            areaStyle.setProperty(53, IStyle.NUMBER_0);
        }
    }

    protected void newContext() {
        this.createRoot();
        IStyle areaStyle = this.root.getStyle();
        this.setOffsetX(this.getDimensionValue(areaStyle.getProperty(17)) + this.getDimensionValue(areaStyle.getProperty(36)));
        this.setOffsetY(this.isFirst ? this.getDimensionValue(areaStyle.getProperty(15)) + this.getDimensionValue(areaStyle.getProperty(56)) : 0);
        int borderWidth = this.getDimensionValue(areaStyle.getProperty(17)) + this.getDimensionValue(areaStyle.getProperty(18));
        int paddingWidth = this.getDimensionValue(areaStyle.getProperty(36)) + this.getDimensionValue(areaStyle.getProperty(37));
        if (borderWidth + paddingWidth < this.columnWidth) {
            this.setMaxAvaWidth(this.columnWidth - borderWidth - paddingWidth);
        } else if (borderWidth < this.columnWidth) {
            this.setMaxAvaWidth(this.columnWidth - borderWidth);
        } else {
            this.setMaxAvaWidth(0);
        }
        this.root.setAllocatedHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
        this.setMaxAvaHeight(this.root.getContentHeight());
        if (this.isFirst) {
            this.isFirst = false;
        }
        this.setCurrentBP(0);
        this.setCurrentIP(0);
    }

    protected void closeLayout() {
        this.root.setHeight(this.getCurrentBP() + this.getOffsetY() + this.getDimensionValue(this.root.getStyle().getProperty(55)));
    }

    protected boolean isHidden() {
        if (this.columnWidth == 0 || !this.tableLM.isCellVisible(this.cellContent)) {
            return true;
        }
        return super.isHidden();
    }

    protected boolean submitRoot(boolean childBreak) {
        if (this.parent != null) {
            this.parent.addArea(this.root);
        }
        return true;
    }

    protected boolean isRootEmpty() {
        return false;
    }

    static {
        $assertionsDisabled = !PDFCellLM.class.desiredAssertionStatus();
    }
}

