/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.text;

import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.ITextLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.DefaultHyphenationManager;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.DefaultWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Hyphenation;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class Compositor {
    private ITextLayoutManager lm = null;
    private ChunkGenerator cg = null;
    private Chunk chunk = null;
    private ITextContent content;
    private boolean isInline;
    private boolean isNew = true;
    private int leftSpaceHolder = 0;
    private int rightSpaceHolder = 0;
    private int vestigeIndex = -1;
    private int vestigeLength = 0;
    private int currentPos = 0;
    private int areaStartPos = 0;
    private int letterSpacing = 0;
    private int wordSpacing = 0;
    private int leftMargin;
    private int leftBorder;
    private int leftPadding;
    private int rightMargin;
    private int rightBorder;
    private int rightPadding;
    private int topBorder;
    private int topPadding;
    private int bottomBorder;
    private int bottomPadding;
    private int maxLineSpace = 0;
    private IWordRecognizer wr = null;
    private boolean addByForce = false;
    private boolean nothingSplitted = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Compositor(ITextContent content, int maxLineSpace, ITextLayoutManager lm) {
        this.lm = lm;
        this.cg = new ChunkGenerator(content);
        this.content = content;
        this.isInline = PropertyUtil.isInlineElement(content);
        this.maxLineSpace = maxLineSpace;
        IStyle style = content.getComputedStyle();
        this.letterSpacing = PropertyUtil.getDimensionValue(style.getProperty(25));
        this.wordSpacing = PropertyUtil.getDimensionValue(style.getProperty(44));
        this.leftMargin = PropertyUtil.getDimensionValue(style.getProperty(31));
        this.leftBorder = PropertyUtil.getDimensionValue(style.getProperty(17));
        this.leftPadding = PropertyUtil.getDimensionValue(style.getProperty(36));
        this.rightMargin = PropertyUtil.getDimensionValue(style.getProperty(32));
        this.rightBorder = PropertyUtil.getDimensionValue(style.getProperty(18));
        this.rightPadding = PropertyUtil.getDimensionValue(style.getProperty(37));
        this.topBorder = PropertyUtil.getDimensionValue(style.getProperty(15));
        this.topPadding = PropertyUtil.getDimensionValue(style.getProperty(56));
        this.bottomBorder = PropertyUtil.getDimensionValue(style.getProperty(19));
        this.bottomPadding = PropertyUtil.getDimensionValue(style.getProperty(55));
    }

    public boolean compose() {
        while (this.hasMore() && !this.lm.needPause()) {
            this.handleNext();
        }
        return this.hasMore();
    }

    private boolean hasMore() {
        if (this.cg.hasMore()) {
            return true;
        }
        if (null == this.chunk) {
            return false;
        }
        if (this.currentPos < this.chunk.getText().length()) {
            return true;
        }
        if (this.isInline) {
            ContainerArea con = (ContainerArea)AreaFactory.createInlineContainer(this.content, false, true);
            con.setWidth(this.rightBorder + this.rightPadding);
            if (null == this.chunk.getFontInfo()) {
                IStyle style = this.content.getComputedStyle();
                con.setHeight(PropertyUtil.getDimensionValue(style.getProperty(38)) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
            } else {
                con.setHeight((int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
            }
            this.lm.addSpaceHolder(con);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleNext() {
        int length;
        int freeSpace = this.lm.getFreeSpace();
        if (this.isNew || this.currentPos == this.chunk.getText().length()) {
            if (!this.cg.hasMore()) {
                return;
            }
            this.chunk = this.cg.getNext();
            if (this.chunk == Chunk.HARD_LINE_BREAK) {
                this.currentPos = this.chunk.getText().length();
                this.lm.newLine();
                return;
            }
            this.currentPos = 0;
            this.wr = new DefaultWordRecognizer(this.chunk.getText());
        }
        if (this.isNew) {
            this.isNew = false;
            if (this.isInline) {
                ContainerArea con = (ContainerArea)AreaFactory.createInlineContainer(this.content, true, false);
                con.setWidth(this.leftBorder + this.leftPadding);
                con.setHeight((int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
                this.lm.addSpaceHolder(con);
                this.leftSpaceHolder = this.leftMargin + this.leftBorder + this.leftPadding;
                freeSpace -= this.leftSpaceHolder;
            }
        }
        String str = null;
        Word currentWord = null;
        if (-1 == this.vestigeIndex) {
            currentWord = this.wr.getNextWord();
            if (null == currentWord) {
                Dimension d = new Dimension(0, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
                IArea builtArea = this.buildArea("", this.content, this.chunk.getOffset(), this.chunk.getOffset(), this.chunk.getFontInfo(), d);
                this.lm.addTextLine(builtArea);
                return;
            }
            str = currentWord.getValue();
            this.areaStartPos = this.chunk.getOffset() + currentWord.getStart();
        } else {
            str = this.chunk.getText().substring(this.vestigeIndex, this.vestigeIndex + this.vestigeLength);
            this.areaStartPos = this.chunk.getOffset() + this.vestigeIndex;
        }
        int prevAreaWidth = 0;
        int areaWidth = (int)(this.chunk.getFontInfo().getWordWidth(this.chunk.getText().substring(this.currentPos, this.currentPos + str.length())) * 1000.0f) + this.letterSpacing * str.length() + this.wordSpacing;
        if (this.isInline && this.isAtLast(this.chunk.getOffset() + this.currentPos + str.length())) {
            this.rightSpaceHolder = this.rightMargin + this.rightBorder + this.rightPadding;
            freeSpace -= this.rightSpaceHolder;
        }
        while (freeSpace >= areaWidth) {
            this.currentPos += str.length();
            currentWord = this.wr.getNextWord();
            if (null == currentWord) {
                str = null;
                break;
            }
            str = currentWord.getValue();
            prevAreaWidth = areaWidth;
            areaWidth += (int)(this.chunk.getFontInfo().getWordWidth(this.chunk.getText().substring(this.currentPos, this.currentPos + str.length())) * 1000.0f) + this.letterSpacing * str.length() + this.wordSpacing;
            if (!this.isAtLast(this.chunk.getOffset() + this.currentPos + str.length())) continue;
            this.rightSpaceHolder = this.rightMargin + this.rightBorder + this.rightPadding;
            freeSpace -= this.rightSpaceHolder;
        }
        if (this.currentPos == (length = this.chunk.getText().length())) {
            Dimension d = new Dimension(areaWidth, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
            String originalText = this.chunk.getText().substring(this.areaStartPos - this.chunk.getOffset(), this.chunk.getText().length());
            IArea builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.areaStartPos, this.chunk.getOffset() + this.chunk.getText().length(), this.chunk.getFontInfo(), d);
            this.lm.addTextLine(builtArea);
            this.vestigeIndex = -1;
            this.vestigeLength = 0;
            return;
        }
        if ((float)this.maxLineSpace < this.chunk.getFontInfo().getWordWidth(str) * 1000.0f + (float)(this.letterSpacing * str.length()) + (float)this.wordSpacing) {
            block19: {
                if (0 == str.length()) {
                    this.vestigeIndex = -1;
                    this.vestigeLength = 0;
                    return;
                }
                DefaultHyphenationManager hm = new DefaultHyphenationManager();
                Hyphenation hyph = hm.getHyphenation(str);
                int endHyphenIndex = this.hyphen(0, freeSpace - prevAreaWidth, hyph, this.chunk.getFontInfo());
                if (endHyphenIndex == 0) {
                    if (this.nothingSplitted) {
                        str = hyph.getHyphenText(0, endHyphenIndex + 1);
                        this.addByForce = true;
                        this.nothingSplitted = false;
                        break block19;
                    } else {
                        this.nothingSplitted = true;
                        this.vestigeIndex = this.currentPos;
                        this.vestigeLength = null == currentWord ? this.vestigeLength : currentWord.getLength();
                        return;
                    }
                }
                str = hyph.getHyphenText(0, endHyphenIndex);
            }
            this.currentPos += str.length();
            this.vestigeIndex = this.currentPos;
            this.vestigeLength = null == currentWord ? this.vestigeLength - str.length() : currentWord.getLength() - str.length();
            Dimension d = null;
            if (this.addByForce) {
                d = new Dimension(freeSpace, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
                this.addByForce = false;
            } else {
                d = new Dimension(prevAreaWidth + (int)(this.chunk.getFontInfo().getWordWidth(str) * 1000.0f) + this.letterSpacing * str.length(), (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
            }
            String originalText = this.chunk.getText().substring(this.areaStartPos - this.chunk.getOffset(), this.vestigeIndex);
            IArea builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.areaStartPos, this.chunk.getOffset() + this.vestigeIndex, this.chunk.getFontInfo(), d);
            this.lm.addTextLine(builtArea);
            this.lm.newLine();
            return;
        }
        Dimension d = new Dimension(prevAreaWidth, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
        String originalText = this.chunk.getText().substring(this.areaStartPos - this.chunk.getOffset(), this.currentPos);
        IArea builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.areaStartPos, this.chunk.getOffset() + this.currentPos, this.chunk.getFontInfo(), d);
        this.lm.addTextLine(builtArea);
        this.lm.newLine();
        this.vestigeIndex = null == currentWord ? -1 : currentWord.getStart();
        this.vestigeLength = null == currentWord ? 0 : currentWord.getLength();
    }

    private IArea buildArea(String text, ITextContent content, int startOffset, int endOffset, FontInfo fi, Dimension dimension) {
        if (this.isInline) {
            return AreaFactory.createInlineTextArea(text, content, startOffset, endOffset, fi, dimension);
        }
        return AreaFactory.createBlockTextArea(text, content, startOffset, endOffset, fi, dimension);
    }

    private int hyphen(int startIndex, int width, Hyphenation hyphenation, FontInfo fi) {
        if (!$assertionsDisabled && startIndex < 0) {
            throw new AssertionError();
        }
        if (startIndex > hyphenation.length() - 1) {
            return -1;
        }
        int last = 0;
        int current = 0;
        for (int i = startIndex + 1; i < hyphenation.length(); ++i) {
            last = current;
            String pre = hyphenation.getHyphenText(startIndex, i);
            current = (int)(fi.getWordWidth(pre) * 1000.0f) + this.letterSpacing * pre.length();
            if (width <= last || width > current) continue;
            return i - 1;
        }
        return hyphenation.length() - 1;
    }

    private String getReverseText(String text) {
        if (this.chunk.getRunDirection() == 0) {
            return text;
        }
        return this.flip(text);
    }

    private String flip(String text) {
        char[] indexChars = text.toCharArray();
        int start = 0;
        int end = indexChars.length;
        int mid = (start + end) / 2;
        --end;
        while (start < mid) {
            char temp = indexChars[start];
            indexChars[start] = indexChars[end];
            indexChars[end] = temp;
            ++start;
            --end;
        }
        return new String(indexChars);
    }

    private boolean isAtLast(int index) {
        return index >= this.content.getText().length();
    }

    static {
        $assertionsDisabled = !Compositor.class.desiredAssertionStatus();
    }
}

