/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.ILabelEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.ITextItemEventHandler;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Label;
import org.eclipse.birt.report.engine.script.internal.instance.LabelInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;

public class LabelScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(LabelHandle labelHandle, ExecutionContext context) {
        try {
            Label label = new Label(labelHandle);
            if (LabelScriptExecutor.handleJS((Object)label, labelHandle.getOnPrepare(), context).didRun()) {
                return;
            }
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelHandle, context);
            if (eh != null) {
                eh.onPrepare(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(ILabelContent content, ExecutionContext context) {
        try {
            ReportItemDesign labelDesign = (ReportItemDesign)content.getGenerateBy();
            LabelInstance label = new LabelInstance(content, context);
            if (LabelScriptExecutor.handleJS((Object)label, labelDesign.getOnCreate(), context).didRun()) {
                return;
            }
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelDesign, context);
            if (eh != null) {
                eh.onCreate(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(ILabelContent content, ExecutionContext context) {
        try {
            ReportItemDesign labelDesign = (ReportItemDesign)content.getGenerateBy();
            LabelInstance label = new LabelInstance(content, context);
            if (LabelScriptExecutor.handleJS((Object)label, labelDesign.getOnRender(), context).didRun()) {
                return;
            }
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelDesign, context);
            if (eh != null) {
                eh.onRender(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(ILabelContent content, ExecutionContext context) {
        try {
            ITextItemEventHandler eh;
            ReportItemDesign labelDesign = (ReportItemDesign)content.getGenerateBy();
            LabelInstance label = new LabelInstance(content, context);
            if (LabelScriptExecutor.handleJS((Object)label, labelDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            if (labelDesign instanceof LabelItemDesign) {
                ILabelEventHandler eh2 = LabelScriptExecutor.getEventHandler(labelDesign, context);
                if (eh2 != null) {
                    eh2.onPageBreak(label, context.getReportContext());
                }
            } else if (labelDesign instanceof TextItemDesign && (eh = LabelScriptExecutor.getEventHandler(labelDesign, context, true)) != null) {
                eh.onPageBreak(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e);
        }
    }

    private static ILabelEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        LabelHandle handle = (LabelHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return LabelScriptExecutor.getEventHandler(handle, context);
    }

    private static ILabelEventHandler getEventHandler(LabelHandle handle, ExecutionContext context) {
        ILabelEventHandler eh = null;
        try {
            eh = (ILabelEventHandler)LabelScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            LabelScriptExecutor.addClassCastException(context, e, handle.getEventHandlerClass(), ILabelEventHandler.class);
        }
        return eh;
    }

    private static ITextItemEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context, boolean isTextItem) {
        if (design.getHandle() instanceof TextItemHandle) {
            TextItemHandle handle = (TextItemHandle)design.getHandle();
            if (handle == null) {
                return null;
            }
            return LabelScriptExecutor.getEventHandler(handle, context);
        }
        return null;
    }

    private static ITextItemEventHandler getEventHandler(TextItemHandle handle, ExecutionContext context) {
        ITextItemEventHandler eh = null;
        try {
            eh = (ITextItemEventHandler)LabelScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            LabelScriptExecutor.addClassCastException(context, e, handle.getEventHandlerClass(), ITextItemEventHandler.class);
        }
        return eh;
    }
}

