/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.ITableEventHandler;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Table;
import org.eclipse.birt.report.engine.script.internal.instance.TableInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class TableScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(TableHandle tableHandle, ExecutionContext context) {
        try {
            Table table = new Table(tableHandle);
            if (TableScriptExecutor.handleJS((Object)table, tableHandle.getOnPrepare(), context).didRun()) {
                return;
            }
            ITableEventHandler eh = TableScriptExecutor.getEventHandler(tableHandle, context);
            if (eh != null) {
                eh.onPrepare(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(TableContent content, ExecutionContext context) {
        try {
            ReportItemDesign tableDesign = (ReportItemDesign)content.getGenerateBy();
            TableInstance table = new TableInstance(content, context);
            if (TableScriptExecutor.handleJS((Object)table, tableDesign.getOnCreate(), context).didRun()) {
                return;
            }
            ITableEventHandler eh = TableScriptExecutor.getEventHandler(tableDesign, context);
            if (eh != null) {
                eh.onCreate(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(ITableContent content, ExecutionContext context) {
        try {
            ReportItemDesign tableDesign = (ReportItemDesign)content.getGenerateBy();
            TableInstance table = new TableInstance(content, context);
            if (TableScriptExecutor.handleJS((Object)table, tableDesign.getOnRender(), context).didRun()) {
                return;
            }
            ITableEventHandler eh = TableScriptExecutor.getEventHandler(tableDesign, context);
            if (eh != null) {
                eh.onRender(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(ITableContent content, ExecutionContext context) {
        try {
            ReportItemDesign tableDesign = (ReportItemDesign)content.getGenerateBy();
            TableInstance table = new TableInstance(content, context);
            if (TableScriptExecutor.handleJS((Object)table, tableDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ITableEventHandler eh = TableScriptExecutor.getEventHandler(tableDesign, context);
            if (eh != null) {
                eh.onPageBreak(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableScriptExecutor.addException(context, e);
        }
    }

    private static ITableEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        TableHandle handle = (TableHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return TableScriptExecutor.getEventHandler(handle, context);
    }

    private static ITableEventHandler getEventHandler(TableHandle handle, ExecutionContext context) {
        ITableEventHandler eh = null;
        try {
            eh = (ITableEventHandler)TableScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            TableScriptExecutor.addClassCastException(context, e, handle.getEventHandlerClass(), ITableEventHandler.class);
        }
        return eh;
    }
}

