/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.toc.TOCEntry;

public class TOCBuilder {
    private TOCNode rootNode;
    private TOCEntry rootEntry;
    public static final String TOC_PREFIX = "__TOC";
    static final /* synthetic */ boolean $assertionsDisabled;

    public TOCBuilder(TOCNode root) {
        this.rootNode = root;
        this.rootEntry = new TOCEntry(null, this.rootNode, this.rootNode);
    }

    public TOCEntry startGroupEntry(TOCEntry parent) {
        if (parent == null) {
            parent = this.rootEntry;
        }
        TOCEntry group = new TOCEntry(parent, parent.getNode(), parent.getNode());
        return group;
    }

    public void closeGroupEntry(TOCEntry group) {
        if (!$assertionsDisabled && group == null) {
            throw new AssertionError();
        }
        TOCEntry parent = group.parent;
        if (parent != null && parent != this.rootEntry && parent.node == parent.root) {
            parent.node = group.node;
        }
    }

    public TOCEntry startEntry(TOCEntry parent, String displayString, String bookmark) {
        if (!$assertionsDisabled && displayString == null) {
            throw new AssertionError();
        }
        if (parent == null) {
            parent = this.rootEntry;
        }
        TOCNode parentNode = parent.node;
        TOCNode node = new TOCNode();
        String id = parentNode.getNodeID();
        if (id == null) {
            id = TOC_PREFIX;
        }
        id = id + "_" + parentNode.getChildren().size();
        node.setNodeID(id);
        node.setDisplayString(displayString);
        node.setBookmark(bookmark == null ? id : bookmark);
        node.setParent(parentNode);
        parentNode.getChildren().add(node);
        TOCEntry entry = new TOCEntry(parent, parent.getRoot(), node);
        return entry;
    }

    public TOCEntry createEntry(TOCEntry parent, String label, String bookmark) {
        TOCEntry entry = this.startEntry(parent, label, bookmark);
        this.closeEntry(entry);
        return entry;
    }

    public void closeEntry(TOCEntry entry) {
        if (!$assertionsDisabled && entry == null) {
            throw new AssertionError();
        }
        TOCEntry parent = entry.parent;
        if (parent != null && parent != this.rootEntry && parent.node == parent.root) {
            parent.node = entry.node;
        }
    }

    public TOCEntry getTOCEntry() {
        return this.rootEntry;
    }

    public TOCNode getTOCNode() {
        return this.rootNode;
    }

    public static void write(TOCNode root, DataOutputStream out) throws IOException {
        IOUtil.writeString((DataOutputStream)out, (String)root.getNodeID());
        IOUtil.writeString((DataOutputStream)out, (String)root.getDisplayString());
        IOUtil.writeString((DataOutputStream)out, (String)root.getBookmark());
        List children = root.getChildren();
        IOUtil.writeInt((OutputStream)out, (int)children.size());
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            TOCNode child = (TOCNode)iter.next();
            TOCBuilder.write(child, out);
        }
        out.flush();
    }

    public static void read(TOCNode node, DataInputStream input) throws IOException {
        String nodeId = IOUtil.readString((DataInputStream)input);
        String displayString = IOUtil.readString((DataInputStream)input);
        String bookmark = IOUtil.readString((DataInputStream)input);
        node.setNodeID(nodeId);
        node.setDisplayString(displayString);
        node.setBookmark(bookmark);
        int size = IOUtil.readInt((InputStream)input);
        for (int i = 0; i < size; ++i) {
            TOCNode child = new TOCNode();
            TOCBuilder.read(child, input);
            child.setParent(node);
            node.getChildren().add(child);
        }
    }

    static {
        $assertionsDisabled = !TOCBuilder.class.desiredAssertionStatus();
    }
}

