/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util.manifest;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.data.oda.OdaException;
import org.eclipse.birt.data.oda.util.manifest.DataTypeMapping;
import org.eclipse.birt.data.oda.util.manifest.ExtensionManifest;
import org.eclipse.birt.data.oda.util.manifest.ManifestExplorer;
import org.eclipse.birt.data.oda.util.manifest.Property;

public class DataSetType {
    private String m_id;
    private String m_displayName;
    private Hashtable m_dataTypeMappings;
    private Property[] m_properties = null;
    private Properties m_propsVisibility;
    static final /* synthetic */ boolean $assertionsDisabled;

    DataSetType(IConfigurationElement dataSetElement) throws OdaException {
        this.m_id = dataSetElement.getAttribute("id");
        if (!$assertionsDisabled && this.m_id == null) {
            throw new AssertionError();
        }
        this.m_displayName = ManifestExplorer.getElementDisplayName(dataSetElement);
        this.m_dataTypeMappings = new Hashtable();
        IConfigurationElement[] typeMappings = dataSetElement.getChildren("dataTypeMapping");
        int numOfTypeMappings = typeMappings.length;
        if (numOfTypeMappings == 0) {
            throw new OdaException(ManifestExplorer.getLocalizedMessage(15, new Object[]{this.m_id}));
        }
        for (int i = 0; i < numOfTypeMappings; ++i) {
            IConfigurationElement typeMapping = typeMappings[i];
            String nativeDataTypeCode = typeMapping.getAttribute("nativeDataTypeCode");
            this.m_dataTypeMappings.put(nativeDataTypeCode, new DataTypeMapping(typeMapping, this.m_id));
        }
        IConfigurationElement[] propertiesElements = dataSetElement.getChildren("properties");
        if (propertiesElements.length > 0) {
            IConfigurationElement propertiesElement = propertiesElements[propertiesElements.length - 1];
            this.m_properties = ExtensionManifest.getPropertyDefinitions(propertiesElement);
            this.m_propsVisibility = ExtensionManifest.getPropertyVisibilities(propertiesElement);
        }
    }

    public String getID() {
        return this.m_id;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public DataTypeMapping getDataTypeMapping(short nativeDataTypeCode) {
        String typeCode = Short.toString(nativeDataTypeCode);
        return (DataTypeMapping)this.m_dataTypeMappings.get(typeCode);
    }

    public DataTypeMapping[] getDataTypeMappings() {
        Collection typeMappings = this.m_dataTypeMappings.values();
        int count = typeMappings.size();
        return typeMappings.toArray(new DataTypeMapping[count]);
    }

    public Property[] getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new Property[0];
        }
        return this.m_properties;
    }

    public Properties getPropertiesVisibility() {
        if (this.m_propsVisibility == null) {
            this.m_propsVisibility = new Properties();
        }
        return this.m_propsVisibility;
    }

    static {
        $assertionsDisabled = !DataSetType.class.desiredAssertionStatus();
    }
}

