/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util.manifest;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.birt.data.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;

public class DtpManifestExplorer {
    private static DtpManifestExplorer sm_instance = null;
    private static org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer sm_dtpExplorer = null;
    private static final String DTP_ODA_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dataSource";
    private static final String BIRT_ODA_EXT_POINT = "org.eclipse.birt.data.oda.dataSource";

    public static DtpManifestExplorer getInstance() {
        if (sm_instance == null) {
            sm_instance = new DtpManifestExplorer();
        }
        if (sm_dtpExplorer == null) {
            sm_dtpExplorer = org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer.getInstance();
        }
        return sm_instance;
    }

    private DtpManifestExplorer() {
    }

    public Properties getDataSourceIdentifiers() {
        ManifestExplorer birtExplorer = ManifestExplorer.getInstance();
        return birtExplorer.getDataSourceIdentifiers();
    }

    public ExtensionManifest getExtensionManifest(String extensionId) throws OdaException {
        ExtensionManifest manifest = sm_dtpExplorer.getExtensionManifest(extensionId, DTP_ODA_EXT_POINT);
        if (manifest != null) {
            return manifest;
        }
        return sm_dtpExplorer.getExtensionManifest(extensionId, BIRT_ODA_EXT_POINT);
    }

    public ExtensionManifest[] getExtensionManifests() {
        int i;
        ExtensionManifest[] dtpManifests = sm_dtpExplorer.getExtensionManifests(DTP_ODA_EXT_POINT, false);
        ExtensionManifest[] birtManifests = sm_dtpExplorer.getExtensionManifests(BIRT_ODA_EXT_POINT, false);
        int dtpCount = dtpManifests.length;
        int birtCount = birtManifests.length;
        if (dtpCount == 0 && birtCount > 0) {
            return birtManifests;
        }
        if (dtpCount == 0 && birtCount == 0) {
            return dtpManifests;
        }
        ArrayList<ExtensionManifest> mergedList = new ArrayList<ExtensionManifest>(dtpCount + birtCount);
        for (i = 0; i < dtpCount; ++i) {
            mergedList.add(dtpManifests[i]);
        }
        for (i = 0; i < birtCount; ++i) {
            mergedList.add(birtManifests[i]);
        }
        int numOfValidExtensions = mergedList.size();
        return mergedList.toArray(new ExtensionManifest[numOfValidExtensions]);
    }
}

