/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URIUtil {
    public static final String FILE_SCHEMA = "file";
    public static final String JAR_SCHEMA = "jar";
    public static final String HTTP_SCHEMA = "http:";
    public static final String JAR_EXTENTION = ".jar";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getLocalPath(String uri) {
        if (uri == null) {
            return null;
        }
        URI objURI = null;
        try {
            objURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            return URIUtil.getLocalFileOfFailedURI(uri);
        }
        if (objURI.getScheme() == null) {
            if (URIUtil.isFileProtocol(uri)) {
                return uri;
            }
        } else {
            if (objURI.getScheme().equalsIgnoreCase(FILE_SCHEMA)) {
                return objURI.getSchemeSpecificPart();
            }
            if (objURI.getScheme().length() == 1 || objURI.getScheme().equalsIgnoreCase(JAR_SCHEMA)) {
                return uri;
            }
        }
        return null;
    }

    private static boolean isFileProtocol(String filePath) {
        File file = new File(filePath);
        return file.toURI().getScheme().equalsIgnoreCase(FILE_SCHEMA);
    }

    private static String getLocalFileOfFailedURI(String uri) {
        URL objURI = null;
        try {
            objURI = new URL(uri);
            if (objURI.getProtocol().equalsIgnoreCase(FILE_SCHEMA)) {
                return objURI.getAuthority() == null ? objURI.getPath() : objURI.getAuthority() + objURI.getPath();
            }
            if (objURI.getProtocol().equalsIgnoreCase(JAR_SCHEMA)) {
                return uri;
            }
            return null;
        }
        catch (MalformedURLException e) {
            File file = new File(uri);
            if (uri.indexOf(JAR_EXTENTION) > -1) {
                return "jar:file:" + file.getAbsolutePath();
            }
            if (uri.startsWith(FILE_SCHEMA)) {
                return file.toURI().getSchemeSpecificPart();
            }
            return uri;
        }
    }

    public static String convertFileNameToURLString(String filePath) {
        StringBuffer buffer = new StringBuffer();
        String path = filePath;
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c < '\u001f' || c == '\u007f') {
                buffer.append("%" + Character.toString(c));
                continue;
            }
            if (c == '#') {
                buffer.append("%23");
                continue;
            }
            if (c == '%') {
                buffer.append("%25");
                continue;
            }
            if (c == '<') {
                buffer.append("%3C");
                continue;
            }
            if (c == '>') {
                buffer.append("%3E");
                continue;
            }
            if (c == '\"') {
                buffer.append("%22");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static URL getDirectory(String filePath) {
        if (filePath == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(URIUtil.convertFileNameToURLString(filePath));
        }
        catch (MalformedURLException e) {
            url = filePath.indexOf(JAR_EXTENTION) > -1 ? URIUtil.getJarDirectory(filePath) : URIUtil.getFileDirectory(filePath);
            return url;
        }
        if (FILE_SCHEMA.equalsIgnoreCase(url.getProtocol())) {
            return URIUtil.getFileDirectory(url.getPath());
        }
        if (JAR_SCHEMA.equalsIgnoreCase(url.getProtocol()) && !url.getPath().toLowerCase().startsWith(HTTP_SCHEMA)) {
            return URIUtil.getJarDirectory(url.getPath());
        }
        return URIUtil.getNetDirectory(url);
    }

    private static URL getNetDirectory(URL filePath) {
        if (!$assertionsDisabled && filePath == null) {
            throw new AssertionError();
        }
        String path = filePath.getFile();
        int index = path.lastIndexOf(47);
        if (index != -1 && index != path.length() - 1) {
            path = path.substring(0, index + 1);
        }
        try {
            return new URL(filePath.getProtocol(), filePath.getHost(), filePath.getPort(), path);
        }
        catch (MalformedURLException malformedURLException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    private static URL getFileDirectory(String filePath) {
        File file = new File(filePath);
        file = file.getAbsoluteFile();
        if ((file = file.getParentFile()) == null) {
            return null;
        }
        try {
            return file.getCanonicalFile().toURL();
        }
        catch (MalformedURLException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static URL getJarDirectory(String filePath) {
        block4: {
            URL url;
            if (filePath.startsWith(FILE_SCHEMA)) {
                filePath = filePath.substring(5);
            }
            if ((url = URIUtil.getFileDirectory(filePath)) != null) {
                try {
                    return new URL("jar:file:" + url.getPath() + '/');
                }
                catch (MalformedURLException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
        return null;
    }

    public static String getRelativePath(String base, String resource) {
        char lastChar;
        int len;
        String baseDir = URIUtil.getLocalPath(base);
        String resourceDir = URIUtil.getLocalPath(resource);
        if (baseDir == null || resourceDir == null) {
            return resource;
        }
        File baseFile = new File(baseDir);
        File resourceFile = new File(resourceDir);
        baseDir = baseFile.getAbsolutePath();
        resourceDir = resourceFile.getAbsolutePath();
        int matchedPos = 0;
        for (matchedPos = 0; matchedPos < baseDir.length() && matchedPos < resourceDir.length() && baseDir.charAt(matchedPos) == resourceDir.charAt(matchedPos); ++matchedPos) {
        }
        if (!URIUtil.isLastDirectoryMatched(baseDir, resourceDir, matchedPos) && !URIUtil.isLastDirectoryMatched(resourceDir, baseDir, matchedPos)) {
            matchedPos = baseDir.lastIndexOf(File.separator, matchedPos);
        }
        int samePrefixPos = matchedPos;
        int upDirs = 0;
        while (matchedPos < baseDir.length() && matchedPos >= 0) {
            matchedPos = baseDir.indexOf(File.separator, matchedPos + 1);
            ++upDirs;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < upDirs; ++i) {
            sb.append("../");
        }
        if (samePrefixPos < resourceDir.length()) {
            String remainPath = resourceDir.substring(samePrefixPos + 1);
            remainPath = remainPath.replace('\\', '/');
            sb.append(remainPath);
        }
        if ((len = sb.length()) > 0 && (lastChar = sb.charAt(len - 1)) == '/') {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    public static String resolveAbsolutePath(String base, String relativePath) {
        File file = new File(relativePath);
        if (file.isAbsolute()) {
            return relativePath;
        }
        String baseDir = URIUtil.getLocalPath(base);
        String relativeDir = URIUtil.getLocalPath(relativePath);
        if (baseDir == null || relativeDir == null) {
            return relativePath;
        }
        File baseFile = new File(baseDir);
        File resourceFile = new File(baseFile, relativeDir);
        return resourceFile.getPath();
    }

    private static boolean isLastDirectoryMatched(String baseDir, String resourceDir, int matchedPos) {
        return matchedPos == baseDir.length() && (matchedPos < resourceDir.length() && resourceDir.charAt(matchedPos) == File.separatorChar || matchedPos == resourceDir.length());
    }

    public static boolean isValidResourcePath(String resourceDir) {
        if (resourceDir == null) {
            return false;
        }
        File f = new File(resourceDir);
        return f.isAbsolute() && f.exists() && f.isDirectory();
    }

    static {
        $assertionsDisabled = !URIUtil.class.desiredAssertionStatus();
    }
}

