/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class MoveContentRecord
extends SimpleRecord {
    protected DesignElement container = null;
    protected DesignElement content = null;
    protected int slot = 0;
    protected int newPosn = 0;
    protected int oldPosn = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MoveContentRecord(DesignElement element, int theSlot, DesignElement obj, int posn) {
        this.container = element;
        this.slot = theSlot;
        this.content = obj;
        this.newPosn = posn;
        if (!$assertionsDisabled && this.container == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.container.getSlot(this.slot) == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.content == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.container.getDefn().getSlot(this.slot).canContain(this.content)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.newPosn >= 0 && this.newPosn < this.container.getSlot(this.slot).getCount())) {
            throw new AssertionError();
        }
        this.oldPosn = this.container.getSlot(this.slot).findPosn(this.content);
        this.label = ModelMessages.getMessage("Message.MoveContent");
    }

    protected void perform(boolean undo) {
        int from = undo ? this.newPosn : this.oldPosn;
        int to = undo ? this.oldPosn : this.newPosn;
        this.container.getSlot(this.slot).moveContent(from, to);
    }

    public DesignElement getTarget() {
        return this.container;
    }

    public NotificationEvent getEvent() {
        return new ContentEvent(this.container, this.content, this.slot, 3);
    }

    protected List getPostTasks() {
        ArrayList<LayoutRecordTask> retValue = new ArrayList<LayoutRecordTask>();
        retValue.addAll(super.getPostTasks());
        if (!(this.content instanceof TableGroup || this.content instanceof TableRow || this.content instanceof Cell)) {
            return retValue;
        }
        ReportItem compoundElement = LayoutUtil.getCompoundContainer(this.container);
        if (compoundElement == null) {
            return retValue;
        }
        retValue.add(new LayoutRecordTask(compoundElement.getRoot(), compoundElement));
        return retValue;
    }

    static {
        $assertionsDisabled = !MoveContentRecord.class.desiredAssertionStatus();
    }
}

