/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.Point;
import org.eclipse.birt.report.model.api.util.Rectangle;
import org.eclipse.birt.report.model.api.validators.MasterPageContextContainmentValidator;
import org.eclipse.birt.report.model.api.validators.MasterPageSizeValidator;
import org.eclipse.birt.report.model.api.validators.MasterPageTypeValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.interfaces.IMasterPageModel;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public abstract class MasterPage
extends StyledElement
implements IMasterPageModel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public MasterPage() {
    }

    public MasterPage(String theName) {
        super(theName);
    }

    public Point getSize(Module module) {
        Point size;
        block13: {
            size = new Point();
            String type = this.getStringProperty(module, "type");
            String height = null;
            String width = null;
            if (type.equalsIgnoreCase("custom")) {
                height = this.getStringProperty(module, "height");
                width = this.getStringProperty(module, "width");
            } else if (type.equalsIgnoreCase("us-letter")) {
                height = "11in";
                width = "8.5in";
            } else if (type.equalsIgnoreCase("us-legal")) {
                height = "14in";
                width = "8.5in";
            } else if (type.equalsIgnoreCase("a4")) {
                height = "297mm";
                width = "210mm";
            } else {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return size;
            }
            try {
                String sessionUnit = module.getSession().getUnits();
                if (height != null) {
                    size.y = DimensionUtil.convertTo(height, sessionUnit, sessionUnit).getMeasure();
                }
                if (width != null) {
                    size.x = DimensionUtil.convertTo(width, sessionUnit, sessionUnit).getMeasure();
                }
            }
            catch (PropertyValueException e) {
                if ($assertionsDisabled) break block13;
                throw new AssertionError();
            }
        }
        return size;
    }

    public boolean isLandscape(Module module) {
        return !this.getStringProperty(module, "type").equalsIgnoreCase("custom") && this.getStringProperty(module, "orientation").equalsIgnoreCase("landscape");
    }

    public boolean isCustomType(Module module) {
        return "custom".equalsIgnoreCase(this.getStringProperty(module, "type"));
    }

    public Rectangle getContentArea(Module module) {
        Point size = this.getSize(module);
        Rectangle margins = new Rectangle();
        margins.y = this.getFloatProperty(module, "topMargin");
        margins.x = this.getFloatProperty(module, "leftMargin");
        margins.height = size.y - margins.y - this.getFloatProperty(module, "bottomMargin");
        margins.width = size.x - margins.x - this.getFloatProperty(module, "rightMargin");
        return margins;
    }

    public List validate(Module module) {
        List list = super.validate(module);
        List pageSizeErrors = MasterPageTypeValidator.getInstance().validate(module, this);
        if (!pageSizeErrors.isEmpty()) {
            list.addAll(pageSizeErrors);
            return list;
        }
        list.addAll(MasterPageSizeValidator.getInstance().validate(module, this));
        return list;
    }

    protected List checkContent(Module module, DesignElement container, int slotId, DesignElement content) {
        List errors = super.checkContent(module, container, slotId, content);
        if (!errors.isEmpty()) {
            return errors;
        }
        errors.addAll(MasterPageContextContainmentValidator.getInstance().validateForAdding(module, container, slotId, content));
        return errors;
    }

    protected List checkContent(Module module, DesignElement container, int slotId, IElementDefn defn) {
        List errors = super.checkContent(module, container, slotId, defn);
        if (!errors.isEmpty()) {
            return errors;
        }
        errors.addAll(MasterPageContextContainmentValidator.getInstance().validateForAdding(module, container, defn));
        return errors;
    }

    private DimensionValue getPredefinedDimension(String propName, boolean isLandScape, String predefinedWidth, String predefinedHeight) throws PropertyValueException {
        if ("height".equals(propName)) {
            if (!isLandScape) {
                return DimensionValue.parse(predefinedHeight);
            }
            return DimensionValue.parse(predefinedWidth);
        }
        if ("width".equals(propName)) {
            if (!isLandScape) {
                return DimensionValue.parse(predefinedWidth);
            }
            return DimensionValue.parse(predefinedHeight);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public Object getProperty(Module module, ElementPropertyDefn prop) {
        block7: {
            String propName = prop.getName();
            if ("height".equals(propName) || "width".equals(propName)) {
                String pageType = (String)this.getProperty(module, "type");
                if ("custom".equalsIgnoreCase(pageType)) {
                    return super.getProperty(module, prop);
                }
                boolean isLandScape = this.isLandscape(module);
                try {
                    if ("a4".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "210mm", "297mm");
                    }
                    if ("us-legal".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "8.5in", "14in");
                    }
                    if ("us-letter".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "8.5in", "11in");
                    }
                }
                catch (PropertyValueException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
        }
        return super.getProperty(module, prop);
    }

    static {
        $assertionsDisabled = !MasterPage.class.desiredAssertionStatus();
    }
}

