/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class IntegerPropertyType
extends PropertyType {
    private static final String DISPLAY_NAME_KEY = "Property.integer";

    public IntegerPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Float) {
            return new Integer(((Float)value).intValue());
        }
        if (value instanceof Double) {
            return new Integer(((Double)value).intValue());
        }
        if (value instanceof String) {
            if (StringUtil.trimString((String)value) == null) {
                return null;
            }
            return this.parseInteger(((String)value).trim());
        }
        if (value instanceof BigDecimal) {
            return new Integer(((BigDecimal)value).intValue());
        }
        if (value instanceof Boolean) {
            return new Integer((Boolean)value != false ? 1 : 0);
        }
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 2);
    }

    public int getTypeCode() {
        return 2;
    }

    public String getName() {
        return "integer";
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        return ((Integer)value).toString();
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        NumberFormat formatter = NumberFormat.getIntegerInstance((ULocale)ThreadResources.getLocale());
        return formatter.format(((Integer)value).doubleValue());
    }

    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    protected Integer parseInteger(String value) throws PropertyValueException {
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 2);
        }
    }
}

