/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;

public class HTMLActionHandler
implements IHTMLActionHandler {
    protected Logger log = Logger.getLogger(HTMLActionHandler.class.getName());
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getURL(IAction actionDefn, Object context) {
        if (actionDefn == null) {
            return null;
        }
        String url = null;
        switch (actionDefn.getType()) {
            case 2: {
                if (actionDefn.getActionString() == null) break;
                url = "#" + actionDefn.getActionString();
                break;
            }
            case 1: {
                url = actionDefn.getActionString();
                break;
            }
            case 3: {
                url = this.buildDrillAction(actionDefn, context);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return url;
    }

    protected String buildDrillAction(IAction action, Object context) {
        String baseURL = null;
        if (context != null) {
            if (context instanceof HTMLRenderContext) {
                baseURL = ((HTMLRenderContext)context).getBaseURL();
            }
            if (context instanceof PDFRenderContext) {
                baseURL = ((PDFRenderContext)context).getBaseURL();
            }
        }
        if (baseURL == null) {
            baseURL = "run";
        }
        StringBuffer link = new StringBuffer();
        String reportName = action.getReportName();
        if (reportName != null && !reportName.equals("")) {
            String format = action.getFormat();
            if (!"html".equalsIgnoreCase(format)) {
                link.append(baseURL.replaceFirst("frameset", "run"));
            } else {
                link.append(baseURL);
            }
            link.append(reportName.toLowerCase().endsWith(".rptdocument") ? "?__document=" : "?__report=");
            try {
                link.append(URLEncoder.encode(reportName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
            if (format != null && format.length() > 0) {
                link.append("&__format=" + format);
            }
            if (action.getParameterBindings() != null) {
                Iterator paramsIte = action.getParameterBindings().entrySet().iterator();
                while (paramsIte.hasNext()) {
                    Map.Entry entry = paramsIte.next();
                    try {
                        String key = (String)entry.getKey();
                        Object valueObj = entry.getValue();
                        if (valueObj == null) continue;
                        String value = ParameterValidationUtil.getDisplayValue(valueObj);
                        link.append("&" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {}
                }
            }
            link.append("&__overwrite=true");
            if (action.getBookmark() != null) {
                try {
                    if (baseURL.lastIndexOf("run") > 0) {
                        link.append("#");
                    } else {
                        link.append("&__bookmark=");
                    }
                    link.append(URLEncoder.encode(action.getBookmark(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
        return link.toString();
    }

    protected void appendReportDesignName(StringBuffer buffer, String reportName) {
        buffer.append("?__report=");
        try {
            buffer.append(URLEncoder.encode(reportName, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void appendFormat(StringBuffer buffer, String format) {
        if (format != null && format.length() > 0) {
            buffer.append("&__format=" + format);
        }
    }

    protected void appendParamter(StringBuffer buffer, String key, Object valueObj) {
        if (valueObj != null) {
            try {
                key = URLEncoder.encode(key, "UTF-8");
                String value = valueObj.toString();
                value = URLEncoder.encode(value, "UTF-8");
                buffer.append("&");
                buffer.append(key);
                buffer.append("=");
                buffer.append(value);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    protected void appendBookmarkAsParamter(StringBuffer buffer, String bookmark) {
        try {
            if (bookmark != null && bookmark.length() != 0) {
                bookmark = URLEncoder.encode(bookmark, "UTF-8");
                buffer.append("&__bookmark=");
                buffer.append(bookmark);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void appendBookmark(StringBuffer buffer, String bookmark) {
        try {
            if (bookmark != null && bookmark.length() != 0) {
                bookmark = URLEncoder.encode(bookmark, "UTF-8");
                buffer.append("#");
                buffer.append(bookmark);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    static {
        $assertionsDisabled = !HTMLActionHandler.class.desiredAssertionStatus();
    }
}

