/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.plugin.CoreUIPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class UIHelper {
    private static boolean STANDALONE_MODE = System.getProperty("STANDALONE") != null;

    public static Point getScreenLocation(Composite cmpTarget) {
        Point ptScreen = new Point(0, 0);
        try {
            Composite cTmp = cmpTarget;
            while (!(cTmp instanceof Shell)) {
                ptScreen.x += cTmp.getLocation().x;
                ptScreen.y += cTmp.getLocation().y;
                cTmp = cTmp.getParent();
            }
        }
        catch (Exception e) {
            WizardBase.displayException(e);
        }
        return cmpTarget.getShell().toDisplay(ptScreen);
    }

    public static void centerOnScreen(Shell shell) {
        shell.setLocation(Display.getCurrent().getPrimaryMonitor().getClientArea().width / 2 - shell.getSize().x / 2, Display.getCurrent().getPrimaryMonitor().getClientArea().height / 2 - shell.getSize().y / 2);
    }

    public static URL getURL(String sPluginRelativePath) {
        URL url = null;
        if (UIHelper.isEclipseMode()) {
            try {
                url = new URL(CoreUIPlugin.getDefault().getBundle().getEntry("/"), sPluginRelativePath);
            }
            catch (MalformedURLException e) {
                WizardBase.displayException(e);
            }
        } else {
            try {
                url = new URL("file:///" + new File(sPluginRelativePath).getAbsolutePath());
            }
            catch (MalformedURLException e) {
                WizardBase.displayException(e);
            }
        }
        return url;
    }

    private static Image createImage(String sPluginRelativePath) {
        Image img = null;
        try {
            try {
                img = new Image((Device)Display.getCurrent(), UIHelper.getURL(sPluginRelativePath).openStream());
            }
            catch (MalformedURLException e1) {
                img = new Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(UIHelper.getURL(sPluginRelativePath).toString()));
            }
        }
        catch (FileNotFoundException e) {
            WizardBase.displayException(e);
        }
        catch (IOException e) {
            WizardBase.displayException(e);
        }
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), 1, 1);
        }
        return img;
    }

    public static Image getImage(String sPluginRelativePath) {
        ImageRegistry registry = JFaceResources.getImageRegistry();
        Image image = registry.get(sPluginRelativePath);
        if (image == null) {
            image = UIHelper.createImage(sPluginRelativePath);
            registry.put(sPluginRelativePath, image);
        }
        return image;
    }

    public static boolean isEclipseMode() {
        return !STANDALONE_MODE && Platform.getExtensionRegistry() != null;
    }
}

