/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import com.ibm.icu.util.Calendar;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class BirtDateTime {
    private static SimpleDateFormat abbrMonthFormat = new SimpleDateFormat("MMM", Locale.getDefault());
    private static SimpleDateFormat monthFormat = new SimpleDateFormat("MMMM", Locale.getDefault());
    private static SimpleDateFormat abbrWeekFormat = new SimpleDateFormat("EEE", Locale.getDefault());
    private static SimpleDateFormat weekFormat = new SimpleDateFormat("EEEE", Locale.getDefault());

    private BirtDateTime() {
    }

    public static int year(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(1);
    }

    public static int quarter(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int month = BirtDateTime.getCalendar(d).get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: {
                return 4;
            }
        }
        return -1;
    }

    public static int month(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(2) + 1;
    }

    public static String month(Date d, int option) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        Calendar c = BirtDateTime.getCalendar(d);
        int month = c.get(2);
        if (option == 1) {
            return String.valueOf(month + 1);
        }
        if (option == 2) {
            return monthFormat.format(d);
        }
        if (option == 3) {
            return abbrMonthFormat.format(d);
        }
        return null;
    }

    public static int week(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(3);
    }

    public static int day(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(5);
    }

    public static int weekDay(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(7);
    }

    public static String weekDay(Date d, int option) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        switch (option) {
            case 1: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 1));
            }
            case 2: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 2));
            }
            case 3: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 2) - 1);
            }
            case 4: {
                return weekFormat.format(d);
            }
            case 5: {
                return abbrWeekFormat.format(d);
            }
        }
        return null;
    }

    public static Timestamp today() {
        Date now = new Date();
        return new Timestamp(now.getYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0);
    }

    public static Timestamp now() {
        Date now = new Date();
        return new Timestamp(now.getTime());
    }

    public static int diffYear(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startYear = BirtDateTime.year(d1);
        int endYear = BirtDateTime.year(d2);
        return endYear - startYear;
    }

    public static int diffMonth(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startMonth = BirtDateTime.year(d1) * 12 + BirtDateTime.month(d1);
        int endMonth = BirtDateTime.year(d2) * 12 + BirtDateTime.month(d2);
        return endMonth - startMonth;
    }

    public static int diffQuarter(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startQuter = BirtDateTime.year(d1) * 4 + BirtDateTime.quarter(d1);
        int endQuter = BirtDateTime.year(d2) * 4 + BirtDateTime.quarter(d2);
        return endQuter - startQuter;
    }

    public static long diffWeek(Date d1, Date d2) {
        Date baseDay = new Date(-1900, 0, 7);
        int diffDay = 1 - BirtDateTime.weekDay(baseDay);
        baseDay = BirtDateTime.addDay(baseDay, diffDay);
        return (BirtDateTime.diffSecond(baseDay, d2) + 1814400000L) / 604800L - (BirtDateTime.diffSecond(baseDay, d1) + 1814400000L) / 604800L;
    }

    public static long diffDay(Date d1, Date d2) {
        return (BirtDateTime.diffSecond(new Date(-1900, 0, 1), d2) + 1814400000L) / 86400L - (BirtDateTime.diffSecond(new Date(-1900, 0, 1), d1) + 1814400000L) / 86400L;
    }

    public static long diffHour(Date d1, Date d2) {
        return (BirtDateTime.diffSecond(new Date(-1900, 0, 1), d2) + 1814400000L) / 3600L - (BirtDateTime.diffSecond(new Date(-1900, 0, 1), d1) + 1814400000L) / 3600L;
    }

    public static long diffMinute(Date d1, Date d2) {
        return (BirtDateTime.diffSecond(new Date(-1900, 0, 1), d2) + 1814400000L) / 60L - (BirtDateTime.diffSecond(new Date(-1900, 0, 1), d1) + 1814400000L) / 60L;
    }

    public static long diffSecond(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        long diff = d2.getTime() - d1.getTime();
        return new Long(diff / 1000L);
    }

    public static Date addYear(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(1, num);
        return startCal.getTime();
    }

    public static Date addMonth(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(2, num);
        return startCal.getTime();
    }

    public static Date addQuarter(Date date, int num) {
        return BirtDateTime.addMonth(date, num * 3);
    }

    public static Date addWeek(Date date, int num) {
        return BirtDateTime.addDay(date, num * 7);
    }

    public static Date addDay(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(5, num);
        return startCal.getTime();
    }

    public static Date addHour(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(11, num);
        return startCal.getTime();
    }

    public static Date addMinute(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(12, num);
        return startCal.getTime();
    }

    public static Date addSecond(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(13, num);
        return startCal.getTime();
    }

    private static int getWeekDay(Date d, int startDay) {
        int dayOfWeek = BirtDateTime.getCalendar(d).get(7);
        if (dayOfWeek >= startDay) {
            return dayOfWeek - startDay + 1;
        }
        return (dayOfWeek - startDay + 1 + 7) % 8;
    }

    private static Calendar getCalendar(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }
}

