/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.flatfile.DataTypes;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSet;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class Query
implements IQuery {
    public static final int DEFAULT_MAX_ROWS = 1000;
    private static final String NAME_LITERAL = "NAME";
    private static final String TYPE_LITERAL = "TYPE";
    private String homeDirectory = null;
    private String currentTableName = null;
    private int maxRows = 0;
    private IConnection connection = null;
    private IResultSetMetaData resultSetMetaData = null;
    private String charSet = null;
    private boolean hasTypeLine = true;

    Query(String homeDir, IConnection host, String charSet, boolean inclTypeLine) throws OdaException {
        if (homeDir == null || host == null) {
            throw new OdaException(Messages.getString("common_ARGUMENT_CANNOT_BE_NULL"));
        }
        this.homeDirectory = homeDir;
        this.connection = host;
        this.charSet = charSet;
        this.hasTypeLine = inclTypeLine;
    }

    public void prepare(String queryText) throws OdaException {
        this.validateOpenConnection();
        String formattedQuery = this.formatQueryText(queryText);
        this.validateQueryText(formattedQuery);
        this.prepareMetaData(formattedQuery);
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void setProperty(String name, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void close() throws OdaException {
        this.currentTableName = null;
        this.homeDirectory = null;
        this.maxRows = 0;
        this.connection = null;
        this.resultSetMetaData = null;
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.maxRows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.resultSetMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        Vector v = this.fetchQueriedDataFromFileToVector();
        String[][] rowSet = this.copyDataFromVectorToTwoDimensionArray(v);
        return new ResultSet(rowSet, this.resultSetMetaData);
    }

    public void setInt(String parameterName, int value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setInt(int parameterId, int value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(String parameterName, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(int parameterId, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int findInParameter(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void clearInParameters() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        throw new UnsupportedOperationException();
    }

    private void validateOpenConnection() throws OdaException {
        if (!this.connection.isOpen()) {
            throw new OdaException(Messages.getString("common_CONNECTION_HAS_NOT_OPEN"));
        }
    }

    private void validateQueryText(String formattedQuery) throws OdaException {
        this.validateNonEmptyQueryText(formattedQuery);
        String[] queryFragments = this.parsePreparedQueryText(formattedQuery);
        this.validateSingleTableQuery(queryFragments);
        this.validateQueryColumnNames(queryFragments);
    }

    private void validateNonEmptyQueryText(String formattedQuery) throws OdaException {
        if (formattedQuery == null || formattedQuery.length() == 0) {
            throw new OdaException(Messages.getString("query_COMMAND_IS_EMPTY"));
        }
    }

    private void validateSingleTableQuery(String[] parsedQuerySegments) throws OdaException {
        if (this.getPreparedTableNames(parsedQuerySegments).split(",").length != 1) {
            throw new OdaException(Messages.getString("query_DO_NOT_SUPPORT_CROSS_TABLE_QUERY"));
        }
    }

    private void validateQueryColumnNames(String[] parsedQuerySegments) throws OdaException {
        String preparedColumnNames = this.getPreparedColumnNames(parsedQuerySegments);
        if (!this.isWildCard(preparedColumnNames)) {
            this.validateColumnName(preparedColumnNames.split(","), this.discoverActualColumnMetaData(this.getPreparedTableNames(parsedQuerySegments), NAME_LITERAL));
        }
    }

    private String getPreparedColumnNames(String[] parsedQueryFragments) {
        return parsedQueryFragments[0];
    }

    private String getPreparedColumnLabels(String[] parsedQueryFragments) {
        return parsedQueryFragments[1];
    }

    private String getPreparedTableNames(String[] parsedQueryFragments) {
        return parsedQueryFragments[2];
    }

    private String[] parsePreparedQueryText(String formattedQuery) throws OdaException {
        String queryWithoutSELECTKeyword = this.stripSELECTKeyword(formattedQuery);
        String[] querySelectAndFromFragments = this.stripFROMKeyword(queryWithoutSELECTKeyword);
        return this.stripASKeyword(querySelectAndFromFragments);
    }

    private String[] stripASKeyword(String[] querySelectAndFromFragments) {
        String[] result = new String[3];
        result[2] = querySelectAndFromFragments[1];
        String selectedColumns = querySelectAndFromFragments[0];
        if (!this.isWildCard(selectedColumns)) {
            String[] columns = selectedColumns.split(",");
            for (int i = 0; i < columns.length; ++i) {
                String[] columnNameAlias = columns[i].split(" AS ");
                if (columnNameAlias == null) continue;
                String string = result[0] = i == 0 ? columnNameAlias[0] : result[0] + "," + columnNameAlias[0].trim();
                result[1] = columnNameAlias.length == 2 ? (i == 0 ? columnNameAlias[1] : result[1] + "," + columnNameAlias[1].trim()) : (i == 0 ? null : result[1] + "," + null);
            }
        } else {
            result[0] = "*";
            result[1] = null;
        }
        return result;
    }

    private String[] stripFROMKeyword(String queryWithoutSELECTKeyword) throws OdaException {
        String[] result = queryWithoutSELECTKeyword.split(" FROM ");
        if (result == null || result.length != 2) {
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
        return result;
    }

    private String stripSELECTKeyword(String formattedQuery) throws OdaException {
        String[] array = formattedQuery.split(" ", 2);
        if (array == null || array.length != 2 || !array[0].trim().equalsIgnoreCase("SELECT")) {
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
        return array[1];
    }

    private String findDataFileAbsolutePath(String tableName) throws OdaException {
        File file = new File(this.homeDirectory + File.separator + tableName.trim());
        if (!file.exists()) {
            throw new OdaException(Messages.getString("query_invalidTableName") + tableName);
        }
        return file.getAbsolutePath();
    }

    private String[] discoverActualColumnMetaData(String tableName, String metaDataType) throws OdaException {
        try {
            String dataFilePath = this.findDataFileAbsolutePath(tableName);
            this.examCharset(dataFilePath);
            FileInputStream fis = new FileInputStream(dataFilePath);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, this.charSet);
            CSVBufferedReader br = new CSVBufferedReader(isr);
            if (!metaDataType.trim().equalsIgnoreCase(NAME_LITERAL) && !metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                throw new OdaException(Messages.getString("query_ARGUMENT_ERROR"));
            }
            if (metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                br.readLine();
            }
            String[] result = this.getColumnNameArray(br.readLine(), metaDataType.trim().equalsIgnoreCase(NAME_LITERAL));
            br.close();
            if (metaDataType.trim().equalsIgnoreCase(NAME_LITERAL)) {
                this.validateUniqueName(result);
            }
            if (metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                this.validateColumnTypeConsistency(result);
            }
            return this.trimStringArray(result);
        }
        catch (IOException e) {
            throw new OdaException(Messages.getString("query_IO_EXCEPTION") + this.findDataFileAbsolutePath(tableName));
        }
    }

    private String[] trimStringArray(String[] array) {
        String[] result = new String[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].trim();
        }
        return result;
    }

    private void validateColumnName(String[] cCN, String[] aCN) throws OdaException {
        for (int i = 0; i < cCN.length; ++i) {
            if (this.findOccuranceOfValueInStringArray(cCN[i], aCN) == 1) continue;
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
    }

    private boolean isWildCard(String cCN) {
        return cCN.equalsIgnoreCase("*");
    }

    private void validateUniqueName(String[] aCN) throws OdaException {
        for (int i = 0; i < aCN.length; ++i) {
            if (this.findOccuranceOfValueInStringArray(aCN[i], aCN) <= 1) continue;
            throw new OdaException(Messages.getString("query_SOURCE_DATA_ERROR"));
        }
    }

    private void validateColumnTypeConsistency(String[] aCT) throws OdaException {
        if (!this.hasTypeLine) {
            return;
        }
        for (int i = 0; i < aCT.length; ++i) {
            if (DataTypes.isValidType(aCT[i])) continue;
            throw new OdaException(Messages.getString("query_SOURCE_DATA_ERROR"));
        }
    }

    private int findOccuranceOfValueInStringArray(String value, String[] array) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!value.trim().equalsIgnoreCase(array[i].trim())) continue;
            ++count;
        }
        return count;
    }

    private int findLocationOfValueInStringArray(String value, String[] array) throws OdaException {
        int result = -1;
        try {
            for (int i = 0; i < array.length; ++i) {
                if (!value.trim().equalsIgnoreCase(array[i].trim())) continue;
                result = i;
                break;
            }
            return result;
        }
        catch (Exception e) {
            throw new OdaException(Messages.getString("query_COLUMN_NAME_ERROR"));
        }
    }

    private Vector fetchQueriedDataFromFileToVector() throws OdaException {
        Vector<String[]> result = new Vector<String[]>();
        try {
            String dataFilePath = this.findDataFileAbsolutePath(this.currentTableName);
            if (this.charSet == null || this.charSet.trim().length() == 0) {
                this.examCharset(dataFilePath);
            }
            FileInputStream fis = new FileInputStream(dataFilePath);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, this.charSet);
            CSVBufferedReader br = new CSVBufferedReader(isr);
            String[] columnNames = this.getColumnNameArray(br.readLine(), true);
            if (this.hasTypeLine) {
                br.readLine();
            }
            String aLine = null;
            for (int fetchCounter = 0; (aLine = br.readLine()) != null && (this.maxRows <= 0 || fetchCounter < this.maxRows); ++fetchCounter) {
                result.add(this.fetchQueriedDataFromRow(aLine, columnNames));
            }
            br.close();
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new OdaException(e.getMessage());
        }
        catch (IOException e) {
            throw new OdaException(e.getMessage());
        }
    }

    private String[] fetchQueriedDataFromRow(String aRow, String[] columnNames) throws OdaException {
        String[] sArray = new String[this.getMetaData().getColumnCount()];
        Vector vTemp = this.splitStringWithDoubleQuotes(aRow);
        for (int i = 0; i < sArray.length; ++i) {
            int location = this.findLocationOfValueInStringArray(this.getMetaData().getColumnName(i + 1), columnNames);
            if (location == -1) continue;
            sArray[i] = vTemp.elementAt(location).toString();
        }
        return sArray;
    }

    private Vector splitStringWithDoubleQuotes(String aRow) {
        String[] aRowArray = aRow.split(",", -1);
        Vector<String> v = new Vector<String>();
        String temp = null;
        boolean isPartOfString = false;
        for (int i = 0; i < aRowArray.length; ++i) {
            if (aRowArray[i].trim().startsWith("\"") && !isPartOfString) {
                if (!aRowArray[i].trim().endsWith("\"")) {
                    temp = aRowArray[i];
                    isPartOfString = true;
                    continue;
                }
                aRowArray[i] = aRowArray[i].trim().substring(1, aRowArray[i].trim().length() - 1);
            }
            if (isPartOfString) {
                temp = temp + "," + aRowArray[i];
                if (!aRowArray[i].trim().endsWith("\"")) continue;
                v.addElement(temp.trim().substring(1, temp.trim().length() - 1));
                temp = null;
                isPartOfString = false;
                continue;
            }
            aRowArray[i] = aRowArray[i].replaceAll("\\Q\"\"\\E", "\"");
            v.addElement(aRowArray[i]);
        }
        return v;
    }

    private String[][] copyDataFromVectorToTwoDimensionArray(Vector v) throws OdaException {
        String[][] rowSet = new String[v.size()][this.resultSetMetaData.getColumnCount()];
        for (int i = 0; i < v.size(); ++i) {
            String[] temp = (String[])v.elementAt(i);
            for (int j = 0; j < temp.length; ++j) {
                rowSet[i][j] = temp[j].trim();
            }
        }
        return rowSet;
    }

    private void prepareMetaData(String queryText) throws OdaException {
        String[] queryFragments = this.parsePreparedQueryText(queryText);
        String tableName = this.getPreparedTableNames(queryFragments);
        String[] allColumnNames = this.discoverActualColumnMetaData(tableName, NAME_LITERAL);
        String[] allColumnTypes = this.hasTypeLine ? this.discoverActualColumnMetaData(tableName, TYPE_LITERAL) : null;
        String[] queryColumnNames = null;
        String[] queryColumnTypes = null;
        if (this.isWildCard(this.getPreparedColumnNames(queryFragments))) {
            queryColumnNames = allColumnNames;
            queryColumnTypes = allColumnTypes;
        } else {
            queryColumnNames = this.getPreparedColumnNames(queryFragments).split(",");
            queryColumnTypes = this.getQueryColumnTypes(allColumnNames, allColumnTypes, queryColumnNames);
        }
        this.resultSetMetaData = new ResultSetMetaData(queryColumnNames, queryColumnTypes, this.getColumnLabels(queryFragments));
        this.currentTableName = tableName;
    }

    private String[] getQueryColumnTypes(String[] allColumnNames, String[] allColumnTypes, String[] queryColumnNames) {
        if (!this.hasTypeLine) {
            return null;
        }
        String[] queryColumnTypes = new String[queryColumnNames.length];
        for (int i = 0; i < queryColumnNames.length; ++i) {
            for (int j = 0; j < allColumnNames.length; ++j) {
                if (!queryColumnNames[i].trim().equalsIgnoreCase(allColumnNames[j])) continue;
                queryColumnTypes[i] = allColumnTypes[j];
            }
        }
        return queryColumnTypes;
    }

    private String[] getColumnLabels(String[] queryFragments) {
        String queryColumnLabels = this.getPreparedColumnLabels(queryFragments);
        return queryColumnLabels != null ? queryColumnLabels.split(",") : null;
    }

    private String formatQueryText(String queryText) {
        String result = "";
        String[] temp = queryText.trim().split(" ");
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i].equalsIgnoreCase("AS")) {
                temp[i] = temp[i].toUpperCase();
            }
            if (temp[i].equalsIgnoreCase("FROM")) {
                temp[i] = temp[i].toUpperCase();
            }
            if (temp[i].equalsIgnoreCase("SELECT")) {
                temp[i] = temp[i].toUpperCase();
            }
            result = result + temp[i] + " ";
        }
        return result.trim();
    }

    private void examCharset(String filepath) throws OdaException, IOException {
        if (this.charSet != null && this.charSet.length() > 0) {
            return;
        }
        FileInputStream fis = new FileInputStream(filepath);
        byte[] byteMarker = new byte[2];
        fis.read(byteMarker);
        this.charSet = byteMarker[0] == -1 && byteMarker[1] == -2 ? "UTF-16LE" : (byteMarker[0] == -2 && byteMarker[1] == -1 ? "UTF-16BE" : "UTF-8");
        fis.close();
    }

    private String[] getColumnNameArray(String line, boolean isFirstLine) throws OdaException {
        if (line == null) {
            throw new OdaException(Messages.getString("common_CANNOT_FIND_COLUMN"));
        }
        String[] result = null;
        if (isFirstLine) {
            try {
                byte[] firstLineByteCodes;
                if ("UTF-8".equals(this.charSet) && this.isUTF8BOMFormat(firstLineByteCodes = line.getBytes(this.charSet))) {
                    line = line.substring(1);
                }
                result = line.split(",");
            }
            catch (UnsupportedEncodingException e) {
                throw new OdaException((Throwable)e);
            }
        } else {
            result = line.split(",");
        }
        return result;
    }

    private boolean isUTF8BOMFormat(byte[] bytecodes) {
        int[] UTF8Prefix = new int[]{-17, -69, -65};
        if (bytecodes.length < UTF8Prefix.length) {
            return false;
        }
        for (int i = 0; i < UTF8Prefix.length; ++i) {
            if (bytecodes[i] == UTF8Prefix[i]) continue;
            return false;
        }
        return true;
    }

    private static class CSVBufferedReader
    extends BufferedReader {
        private Reader in;
        private char[] cb;
        private int nChars;
        private int nextChar;
        private static final int INVALIDATED = -2;
        private static final int UNMARKED = -1;
        private int markedChar = -1;
        private int readAheadLimit = 0;
        private boolean skipLF = false;
        private final int defaultCharBufferSize = 8192;
        private final int defaultExpectedLineLength = 80;

        public CSVBufferedReader(Reader in) {
            super(in);
            this.in = in;
            this.cb = new char[8192];
            this.nChars = 0;
            this.nextChar = 0;
        }

        public String readLine() throws IOException {
            return this.readNewLine(false);
        }

        private String readNewLine(boolean ignoreLF) throws IOException {
            StringBuffer s = null;
            boolean omitLF = ignoreLF || this.skipLF;
            Object object = this.lock;
            synchronized (object) {
                if (this.in == null) {
                    throw new IOException(Messages.getString("query_streamClosed"));
                }
                while (true) {
                    int i;
                    if (this.nextChar >= this.nChars) {
                        this.fill();
                    }
                    if (this.nextChar >= this.nChars) {
                        if (s != null && s.length() > 0) {
                            return s.toString();
                        }
                        return null;
                    }
                    boolean eol = false;
                    char c1 = '\u0000';
                    if (!omitLF || this.cb[this.nextChar] == '\n') {
                        // empty if block
                    }
                    this.skipLF = false;
                    omitLF = false;
                    for (i = ++this.nextChar; i < this.nChars; ++i) {
                        c1 = this.cb[i];
                        if (!this.isNewLine(c1, i)) continue;
                        eol = true;
                        break;
                    }
                    int startChar = this.nextChar;
                    this.nextChar = i;
                    if (eol) {
                        String str;
                        if (s == null) {
                            str = new String(this.cb, startChar, i - startChar);
                        } else {
                            s.append(this.cb, startChar, i - startChar);
                            str = s.toString();
                        }
                        ++this.nextChar;
                        if (c1 == '\r') {
                            this.skipLF = true;
                        }
                        return str;
                    }
                    if (s == null) {
                        s = new StringBuffer(80);
                    }
                    s.append(this.cb, startChar, i - startChar);
                }
            }
        }

        private void fill() throws IOException {
            int n;
            int dst;
            if (this.markedChar <= -1) {
                dst = 0;
            } else {
                int delta = this.nextChar - this.markedChar;
                if (delta >= this.readAheadLimit) {
                    this.markedChar = -2;
                    this.readAheadLimit = 0;
                    dst = 0;
                } else {
                    if (this.readAheadLimit <= this.cb.length) {
                        System.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                        this.markedChar = 0;
                        dst = delta;
                    } else {
                        char[] ncb = new char[this.readAheadLimit];
                        System.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                        this.cb = ncb;
                        this.markedChar = 0;
                        dst = delta;
                    }
                    this.nextChar = this.nChars = delta;
                }
            }
            while ((n = this.in.read(this.cb, dst, this.cb.length - dst)) == 0) {
            }
            if (n > 0) {
                this.nChars = dst + n;
                this.nextChar = dst;
            }
        }

        public void close() throws IOException {
            super.close();
        }

        private boolean isNewLine(char c1, int index) {
            if (c1 == '\n') {
                return true;
            }
            return c1 == '\r' && this.cb.length > index + 1 && this.cb[index + 1] == '\n';
        }
    }
}

