/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public abstract class FileUtil {
    private static final int BUFFER_SIZE = 16384;

    public static boolean removeDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!(file2.isDirectory() ? !FileUtil.removeDirectory(file2) : !file2.delete())) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean removeDirectory(String string) {
        return FileUtil.removeDirectory(new File(string));
    }

    public static boolean copyDirectory(File file, File file2) {
        return FileUtil.copyDirectory(file, file2, null, null);
    }

    public static boolean copyDirectory(String string, String string2) {
        return FileUtil.copyDirectory(new File(string), new File(string2));
    }

    public static boolean copyDirectory(File file, File file2, byte[] byArray, String[] stringArray) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        if (file2.exists()) {
            return false;
        }
        if (!file2.mkdirs()) {
            return false;
        }
        String[] stringArray2 = file.list();
        if (stringArray2 != null) {
            if (byArray == null) {
                byArray = new byte[16384];
            }
            block0: for (int i = 0; i < stringArray2.length; ++i) {
                File file3;
                String string = stringArray2[i];
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (string.equals(stringArray[j])) continue block0;
                    }
                }
                if (!((file3 = new File(file, string)).isDirectory() ? !FileUtil.copyDirectory(file3, new File(file2, string), byArray, stringArray) : !FileUtil.copyFile(file3, new File(file2, string), byArray))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(File file, File file2) {
        return FileUtil.copyFile(file, file2, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copyFile(File file, File file2, byte[] byArray) {
        block22: {
            IOException iOException2222;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            block19: {
                if (byArray == null) {
                    byArray = new byte[16384];
                }
                fileInputStream = null;
                fileOutputStream = null;
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                int n = fileInputStream.read(byArray);
                while (n != -1) {
                    fileOutputStream.write(byArray, 0, n);
                    n = fileInputStream.read(byArray);
                }
                fileInputStream.close();
                fileInputStream = null;
                fileOutputStream.getFD().sync();
                fileOutputStream.close();
                fileOutputStream = null;
                Object var8_7 = null;
                if (fileInputStream == null) break block19;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block22;
            {
                catch (IOException iOException3) {
                    IOException iOException42222;
                    boolean bl = false;
                    Object var8_8 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                IOException iOException52222;
                Object var8_9 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return true;
    }

    public static boolean copyDirectory(StorageFactory storageFactory, StorageFile storageFile, File file) {
        return FileUtil.copyDirectory(storageFactory, storageFile, file, null, null);
    }

    public static boolean copyDirectory(StorageFactory storageFactory, StorageFile storageFile, File file, byte[] byArray, String[] stringArray) {
        if (storageFile == null) {
            return false;
        }
        if (!storageFile.exists()) {
            return true;
        }
        if (!storageFile.isDirectory()) {
            return false;
        }
        if (file.exists()) {
            return false;
        }
        if (!file.mkdirs()) {
            return false;
        }
        String[] stringArray2 = storageFile.list();
        if (stringArray2 != null) {
            if (byArray == null) {
                byArray = new byte[16384];
            }
            block0: for (int i = 0; i < stringArray2.length; ++i) {
                StorageFile storageFile2;
                String string = stringArray2[i];
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (string.equals(stringArray[j])) continue block0;
                    }
                }
                if (!((storageFile2 = storageFactory.newStorageFile(storageFile, string)).isDirectory() ? !FileUtil.copyDirectory(storageFactory, storageFile2, new File(file, string), byArray, stringArray) : !FileUtil.copyFile(storageFactory, storageFile2, new File(file, string), byArray))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(StorageFactory storageFactory, StorageFile storageFile, File file) {
        return FileUtil.copyFile(storageFactory, storageFile, file, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copyFile(StorageFactory storageFactory, StorageFile storageFile, File file, byte[] byArray) {
        block22: {
            IOException iOException2222;
            FileOutputStream fileOutputStream;
            InputStream inputStream;
            block19: {
                inputStream = null;
                fileOutputStream = null;
                inputStream = storageFile.getInputStream();
                fileOutputStream = new FileOutputStream(file);
                if (byArray == null) {
                    byArray = new byte[16384];
                }
                int n = inputStream.read(byArray);
                while (n != -1) {
                    fileOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                inputStream.close();
                inputStream = null;
                fileOutputStream.getFD().sync();
                fileOutputStream.close();
                fileOutputStream = null;
                Object var9_8 = null;
                if (inputStream == null) break block19;
                try {
                    inputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block22;
            {
                catch (IOException iOException3) {
                    IOException iOException42222;
                    boolean bl = false;
                    Object var9_9 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                IOException iOException52222;
                Object var9_10 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return true;
    }

    public static boolean copyDirectory(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile) {
        return FileUtil.copyDirectory(writableStorageFactory, file, storageFile, null, null);
    }

    public static boolean copyDirectory(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile, byte[] byArray, String[] stringArray) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        if (storageFile.exists()) {
            return false;
        }
        if (!storageFile.mkdirs()) {
            return false;
        }
        String[] stringArray2 = file.list();
        if (stringArray2 != null) {
            if (byArray == null) {
                byArray = new byte[16384];
            }
            block0: for (int i = 0; i < stringArray2.length; ++i) {
                File file2;
                String string = stringArray2[i];
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (string.equals(stringArray[j])) continue block0;
                    }
                }
                if (!((file2 = new File(file, string)).isDirectory() ? !FileUtil.copyDirectory(writableStorageFactory, file2, writableStorageFactory.newStorageFile(storageFile, string), byArray, stringArray) : !FileUtil.copyFile(writableStorageFactory, file2, writableStorageFactory.newStorageFile(storageFile, string), byArray))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile) {
        return FileUtil.copyFile(writableStorageFactory, file, storageFile, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copyFile(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile, byte[] byArray) {
        block22: {
            IOException iOException2222;
            OutputStream outputStream;
            FileInputStream fileInputStream;
            block19: {
                fileInputStream = null;
                outputStream = null;
                fileInputStream = new FileInputStream(file);
                outputStream = storageFile.getOutputStream();
                if (byArray == null) {
                    byArray = new byte[16384];
                }
                int n = ((InputStream)fileInputStream).read(byArray);
                while (n != -1) {
                    outputStream.write(byArray, 0, n);
                    n = ((InputStream)fileInputStream).read(byArray);
                }
                ((InputStream)fileInputStream).close();
                fileInputStream = null;
                writableStorageFactory.sync(outputStream, false);
                outputStream.close();
                outputStream = null;
                Object var9_8 = null;
                if (fileInputStream == null) break block19;
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block22;
            {
                catch (IOException iOException3) {
                    IOException iOException42222;
                    boolean bl = false;
                    Object var9_9 = null;
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                IOException iOException52222;
                Object var9_10 = null;
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return true;
    }

    public static File getAbsoluteFile(File file, String string) {
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            return file2;
        }
        if (file == null) {
            return null;
        }
        return new File(file, string);
    }

    public static File newFile(File file, String string) {
        if (file == null) {
            return new File(string);
        }
        return new File(file, string);
    }

    public static InputStream getInputStream(String string, int n) throws IOException {
        InputStream inputStream;
        try {
            inputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                inputStream = new URL(string).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                if (string.indexOf(58) > 2) {
                    throw malformedURLException;
                }
                throw fileNotFoundException;
            }
        }
        if (n > 0) {
            inputStream = new BufferedInputStream(inputStream, n);
        }
        return inputStream;
    }
}

