/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement30;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement30;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;

public class BrokeredConnection30
extends BrokeredConnection {
    private int stateHoldability = 1;

    public final Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            this.control.checkHoldCursors(n3);
            return this.control.wrapStatement(this.getRealConnection().createStatement(n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.control.checkHoldCursors(n3);
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, n, n2, n3), string, null);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.control.checkHoldCursors(n3);
            return this.control.wrapStatement(this.getRealConnection().prepareCall(string, n, n2, n3), string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final Savepoint setSavepoint() throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final Savepoint setSavepoint(String string) throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getRealConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final int getHoldability() throws SQLException {
        try {
            return this.getRealConnection().getHoldability();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final void setHoldability(int n) throws SQLException {
        try {
            this.control.checkHoldCursors(n);
            this.getRealConnection().setHoldability(n);
            this.stateHoldability = n;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, n), string, new Integer(n));
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, nArray), string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public final PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(string, stringArray), string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public void syncState() throws SQLException {
        super.syncState();
        this.getRealConnection().setHoldability(this.stateHoldability);
    }

    public void setState(boolean bl) throws SQLException {
        super.setState(bl);
        if (bl) {
            this.getRealConnection().setHoldability(this.stateHoldability);
        }
    }

    public BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl, String string, Object object) throws SQLException {
        return new BrokeredPreparedStatement30(brokeredStatementControl, this.getJDBCLevel(), string, object);
    }

    public BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl, String string) throws SQLException {
        return new BrokeredCallableStatement30(brokeredStatementControl, this.getJDBCLevel(), string);
    }

    protected int getJDBCLevel() {
        return 3;
    }

    public BrokeredConnection30(BrokeredConnectionControl brokeredConnectionControl) {
        super(brokeredConnectionControl);
    }
}

