/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.StringUtil;

public class SQLLongvarchar
extends SQLVarchar {
    public String getTypeName() {
        return "LONG VARCHAR";
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLLongvarchar(this.getString());
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLLongvarchar();
    }

    public int getTypeFormatId() {
        return 235;
    }

    protected void normalize(DataTypeDescriptor dataTypeDescriptor, String string) throws StandardException {
        if (string.length() > dataTypeDescriptor.getMaximumWidth()) {
            throw StandardException.newException("22001", this.getTypeName(), (Object)StringUtil.formatForPrint(string), (Object)String.valueOf(dataTypeDescriptor.getMaximumWidth()));
        }
        this.setValue(string);
    }

    public StringDataValue concatenate(StringDataValue stringDataValue, StringDataValue stringDataValue2, StringDataValue stringDataValue3) throws StandardException {
        super.concatenate(stringDataValue, stringDataValue2, stringDataValue3);
        if (stringDataValue3.getString() != null && stringDataValue3.getString().length() > 32700) {
            throw StandardException.newException("54006", "CONCAT", (Object)String.valueOf(32700));
        }
        return stringDataValue3;
    }

    public int typePrecedence() {
        return 12;
    }

    public SQLLongvarchar() {
    }

    public SQLLongvarchar(String string) {
        super(string);
    }
}

