/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.derby.impl.load.LoadError;

class ColumnInfo {
    private ArrayList vtiColumnNames = new ArrayList(1);
    private ArrayList insertColumnNames = new ArrayList(1);
    private ArrayList columnTypes = new ArrayList(1);
    private int noOfColumns = 0;
    private ArrayList columnPositions;
    private boolean createolumnNames = true;
    private int expectedNumberOfCols;
    private Connection conn;
    private String tableName;
    private String schemaName;

    private boolean initializeColumnInfo(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, this.schemaName, this.tableName, string != null ? string.toUpperCase(Locale.ENGLISH) : string);
        boolean bl = false;
        while (resultSet.next()) {
            String string2 = resultSet.getString(4);
            short s = resultSet.getShort(5);
            String string3 = resultSet.getString(6);
            int n = resultSet.getInt(7);
            int n2 = resultSet.getInt(9);
            int n3 = resultSet.getInt(10);
            bl = true;
            if (ColumnInfo.importExportSupportedType(s)) {
                this.insertColumnNames.add(string2);
                String string4 = string3 + this.getTypeOption(string3, n, n, n2);
                this.columnTypes.add(this.noOfColumns, string4);
                ++this.noOfColumns;
                continue;
            }
            resultSet.close();
            throw LoadError.nonSupportedTypeColumn(string2, string3);
        }
        resultSet.close();
        return bl;
    }

    public static final boolean importExportSupportedType(int n) {
        return !(n == -2 || n == -7 || n == 2000 || n == 1111 || n == 2005 || n == 2004);
    }

    private String getTypeOption(String string, int n, int n2, int n3) {
        if ((string.equals("CHAR") || string.equals("BLOB") || string.equals("CLOB") || string.equals("VARCHAR")) && n != 0) {
            return "(" + n + ")";
        }
        if (string.equals("FLOAT") && n2 != 0) {
            return "(" + n2 + ")";
        }
        if (string.equals("DECIMAL") || string.equals("NUMERIC")) {
            if (n2 != 0 && n3 == 0) {
                return "(" + n2 + ")";
            }
            if (n2 != 0 && n3 != 0) {
                return "(" + n2 + "," + n3 + ")";
            }
            if (n2 == 0 && n3 != 0) {
                return "(" + n3 + ")";
            }
        }
        if ((string.equals("DECIMAL") || string.equals("NUMERIC")) && n3 != 0) {
            return "(" + n3 + ")";
        }
        return "";
    }

    public String getColumnNamesWithCasts() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = this.vtiColumnNames.size();
        int n2 = 0;
        while (n2 < this.noOfColumns && n2 < n) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            String string = (String)this.columnTypes.get(n2);
            String string2 = (String)this.vtiColumnNames.get(n2);
            if (string.startsWith("SMALLINT") || string.startsWith("INTEGER") || string.startsWith("DECIMAL") || string.startsWith("BIGINT") || string.startsWith("NUMERIC")) {
                stringBuffer.append(" cast(" + string2 + " AS " + string + ") ");
            } else if (string.startsWith("DOUBLE")) {
                stringBuffer.append(" DOUBLE(" + string2 + ") ");
            } else if (string.startsWith("REAL")) {
                stringBuffer.append("cast( DOUBLE(" + string2 + ") " + " AS " + "REAL" + ") ");
            } else {
                stringBuffer.append(" " + string2 + " ");
            }
            ++n2;
        }
        if (bl) {
            return " * ";
        }
        return stringBuffer.toString();
    }

    public String getInsertColumnNames() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        while (n < this.noOfColumns) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(this.insertColumnNames.get(n));
            ++n;
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getExpectedNumberOfColumnsInFile() {
        return this.expectedNumberOfCols;
    }

    private boolean tableExists() throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, this.schemaName, this.tableName, null);
        boolean bl = false;
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        return bl;
    }

    public ColumnInfo(Connection connection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        String string6;
        StringTokenizer stringTokenizer;
        this.conn = connection;
        this.schemaName = string != null ? string.toUpperCase(Locale.ENGLISH) : string;
        String string7 = this.tableName = string2 != null ? string2.toUpperCase(Locale.ENGLISH) : string2;
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken().trim();
                if (this.initializeColumnInfo(string6)) continue;
                if (this.tableExists()) {
                    throw LoadError.invalidColumnName(string6);
                }
                String string8 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
                throw LoadError.tableNotFound(string8);
            }
        } else if (!this.initializeColumnInfo(null)) {
            String string9 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
            throw LoadError.tableNotFound(string9);
        }
        if (string4 != null) {
            stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken().trim();
                this.vtiColumnNames.add(string5 + string6);
                int n = new Integer(string6);
                if (n <= this.expectedNumberOfCols) continue;
                this.expectedNumberOfCols = n;
            }
        }
        if (this.vtiColumnNames.size() < 1) {
            int n = 1;
            while (n <= this.noOfColumns) {
                this.vtiColumnNames.add(string5 + n);
                ++n;
            }
            this.expectedNumberOfCols = this.noOfColumns;
        }
    }
}

