/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public class TableNameInfo {
    private DataDictionary dd;
    private Hashtable ddCache;
    private Hashtable tdCache;
    private Hashtable tableCache = new Hashtable(31);
    private Hashtable indexCache;

    public String getTableName(Long l) {
        if (l == null) {
            return "?";
        }
        TableDescriptor tableDescriptor = (TableDescriptor)this.tableCache.get(l);
        if (tableDescriptor == null) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.ddCache.get(l);
            if (conglomerateDescriptor != null) {
                tableDescriptor = (TableDescriptor)this.tdCache.get(conglomerateDescriptor.getTableID());
            }
            if (conglomerateDescriptor == null || tableDescriptor == null) {
                String string;
                if (l > 20L) {
                    string = "*** TRANSIENT_" + l;
                } else {
                    switch (l.intValue()) {
                        case 0: {
                            string = "*** INVALID CONGLOMERATE ***";
                            break;
                        }
                        case 1: {
                            string = "ConglomerateDirectory";
                            break;
                        }
                        case 2: {
                            string = "PropertyConglomerate";
                            break;
                        }
                        default: {
                            string = "*** INTERNAL TABLE " + l;
                            break;
                        }
                    }
                }
                return string;
            }
            this.tableCache.put(l, tableDescriptor);
            if (this.indexCache != null && conglomerateDescriptor.isIndex()) {
                this.indexCache.put(l, conglomerateDescriptor.getConglomerateName());
            }
        }
        return tableDescriptor.getName();
    }

    public String getTableType(Long l) {
        String string;
        if (l == null) {
            return "?";
        }
        TableDescriptor tableDescriptor = (TableDescriptor)this.tableCache.get(l);
        if (tableDescriptor != null) {
            switch (tableDescriptor.getTableType()) {
                case 0: {
                    string = "T";
                    break;
                }
                case 1: {
                    string = "S";
                    break;
                }
                default: {
                    string = "?";
                    break;
                }
            }
        } else {
            string = l > 20L ? "T" : "S";
        }
        return string;
    }

    public String getIndexName(Long l) {
        if (l == null) {
            return "?";
        }
        return (String)this.indexCache.get(l);
    }

    public TableNameInfo(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        if (bl) {
            this.indexCache = new Hashtable(13);
        }
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        this.dd = languageConnectionContext.getDataDictionary();
        this.ddCache = this.dd.hashAllConglomerateDescriptorsByNumber(transactionController);
        this.tdCache = this.dd.hashAllTableDescriptorsByTableId(transactionController);
    }
}

