/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSFILESRowFactory
extends CatalogRowFactory {
    protected static final String TABLENAME_STRING = "SYSFILES";
    protected static final int SYSFILES_COLUMN_COUNT = 4;
    protected static final int ID_COL_NUM = 1;
    protected static final String ID_COL_NAME = "FILEID";
    protected static final int SCHEMA_ID_COL_NUM = 2;
    protected static final String SCHEMA_ID_COL_NAME = "SCHEMAID";
    protected static final int NAME_COL_NUM = 3;
    protected static final String NAME_COL_NAME = "FILENAME";
    protected static final int GENERATION_ID_COL_NUM = 4;
    protected static final String GENERATION_ID_COL_NAME = "GENERATIONID";
    protected static final int SYSFILES_INDEX1_ID = 0;
    protected static final int SYSFILES_INDEX2_ID = 1;
    private static final int[][] indexColumnPositions = new int[][]{{3, 2}, {1}};
    private static final String[][] indexColumnNames = new String[][]{{"FILENAME", "SCHEMAID"}, {"FILEID"}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"80000000-00d3-e222-873f-000a0a0b1900", "80000000-00d3-e222-9920-000a0a0b1900", "80000000-00d3-e222-a373-000a0a0b1900", "80000000-00d3-e222-be7b-000a0a0b1900"};

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        long l = 0L;
        if (tupleDescriptor != null) {
            FileInfoDescriptor fileInfoDescriptor = (FileInfoDescriptor)tupleDescriptor;
            string = fileInfoDescriptor.getUUID().toString();
            string2 = fileInfoDescriptor.getSchemaDescriptor().getUUID().toString();
            string3 = fileInfoDescriptor.getName();
            l = fileInfoDescriptor.getGenerationId();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(4);
        execRow.setColumn(1, this.dvf.getCharDataValue(string));
        execRow.setColumn(2, this.dvf.getCharDataValue(string2));
        execRow.setColumn(3, this.dvf.getVarcharDataValue(string3));
        execRow.setColumn(4, this.dvf.getDataValue(l));
        return execRow;
    }

    public ExecIndexRow buildEmptyIndexRow(int n, RowLocation rowLocation) throws StandardException {
        int n2 = this.getIndexColumnCount(n);
        ExecIndexRow execIndexRow = this.getExecutionFactory().getIndexableRow(n2 + 1);
        execIndexRow.setColumn(n2 + 1, rowLocation);
        switch (n) {
            case 0: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getVarcharDataValue(null));
                execIndexRow.setColumn(2, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
            case 1: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
        }
        return execIndexRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string2);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(uUID2, null);
        dataValueDescriptor = execRow.getColumn(3);
        String string3 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(4);
        long l = dataValueDescriptor.getLong();
        FileInfoDescriptor fileInfoDescriptor = dataDescriptorGenerator.newFileInfoDescriptor(uUID, schemaDescriptor, string3, l);
        return fileInfoDescriptor;
    }

    public SystemColumn[] buildColumnList() {
        int n = 0;
        SystemColumn[] systemColumnArray = new SystemColumn[4];
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase(ID_COL_NAME), 1, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase(SCHEMA_ID_COL_NAME), 2, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase(NAME_COL_NAME), 3, false);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase(GENERATION_ID_COL_NAME), 4, 0, 0, false, "BIGINT", true, 8);
        return systemColumnArray;
    }

    public SYSFILESRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(4, TABLENAME_STRING, indexColumnPositions, indexColumnNames, uniqueness, uuids);
    }
}

