/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

class AccessPathImpl
implements AccessPath {
    ConglomerateDescriptor cd = null;
    private CostEstimate costEstimate = null;
    boolean coveringIndexScan = false;
    boolean nonMatchingIndexScan = false;
    JoinStrategy joinStrategy = null;
    int lockMode;
    Optimizer optimizer;
    private String accessPathName = "";

    public void setConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor) {
        this.cd = conglomerateDescriptor;
    }

    public ConglomerateDescriptor getConglomerateDescriptor() {
        return this.cd;
    }

    public void setCostEstimate(CostEstimate costEstimate) {
        if (this.costEstimate == null) {
            if (costEstimate != null) {
                this.costEstimate = costEstimate.cloneMe();
            }
        } else if (costEstimate == null) {
            this.costEstimate = null;
        } else {
            this.costEstimate.setCost(costEstimate);
        }
    }

    public CostEstimate getCostEstimate() {
        return this.costEstimate;
    }

    public void setCoveringIndexScan(boolean bl) {
        this.coveringIndexScan = bl;
    }

    public boolean getCoveringIndexScan() {
        return this.coveringIndexScan;
    }

    public void setNonMatchingIndexScan(boolean bl) {
        this.nonMatchingIndexScan = bl;
    }

    public boolean getNonMatchingIndexScan() {
        return this.nonMatchingIndexScan;
    }

    public void setJoinStrategy(JoinStrategy joinStrategy) {
        this.joinStrategy = joinStrategy;
    }

    public JoinStrategy getJoinStrategy() {
        return this.joinStrategy;
    }

    public void setLockMode(int n) {
        this.lockMode = n;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public void copy(AccessPath accessPath) {
        this.setConglomerateDescriptor(accessPath.getConglomerateDescriptor());
        this.setCostEstimate(accessPath.getCostEstimate());
        this.setCoveringIndexScan(accessPath.getCoveringIndexScan());
        this.setNonMatchingIndexScan(accessPath.getNonMatchingIndexScan());
        this.setJoinStrategy(accessPath.getJoinStrategy());
        this.setLockMode(accessPath.getLockMode());
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public String toString() {
        return "";
    }

    public void initializeAccessPathName(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        if (this.cd == null) {
            return;
        }
        if (this.cd.isConstraint()) {
            ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, this.cd.getUUID());
            if (constraintDescriptor == null) {
                throw StandardException.newException("42X94", "CONSTRAINT on TABLE", (Object)tableDescriptor.getName());
            }
            this.accessPathName = constraintDescriptor.getConstraintName();
        } else {
            this.accessPathName = this.cd.isIndex() ? this.cd.getConglomerateName() : "";
        }
    }

    AccessPathImpl(Optimizer optimizer) {
        this.optimizer = optimizer;
    }
}

