/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class AggregateNode
extends UnaryOperatorNode {
    private boolean distinct;
    private AggregateDefinition uad;
    private StringBuffer aggregatorClassName;
    private String aggregateDefinitionClassName;
    private Class aggregateDefinitionClass;
    private ClassInspector classInspector;
    private String aggregateName;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$sql$compile$MaxMinAggregateDefinition;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$sql$compile$ResultSetNode;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        super.init(object);
        this.aggregateName = (String)object4;
        if (object2 instanceof String) {
            this.aggregateDefinitionClassName = (String)object2;
            this.distinct = (Boolean)object3;
        } else {
            this.aggregateDefinitionClass = (Class)object2;
            this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
            if (!this.aggregateDefinitionClass.equals(class$Lorg$apache$derby$impl$sql$compile$MaxMinAggregateDefinition != null ? class$Lorg$apache$derby$impl$sql$compile$MaxMinAggregateDefinition : (class$Lorg$apache$derby$impl$sql$compile$MaxMinAggregateDefinition = AggregateNode.class$("org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition")))) {
                this.distinct = (Boolean)object3;
            }
        }
    }

    public ValueNode replaceAggregatesWithColumnReferences(ResultColumnList resultColumnList, int n) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext compilerContext = this.getCompilerContext();
            String string = "SQLCol" + compilerContext.getNextColumnNumber();
            this.generatedRC = (ResultColumn)this.getNodeFactory().getNode(80, string, this, this.getContextManager());
            this.generatedRC.markGenerated();
            if (this.getTypeServices() == null) {
                this.generatedRef = (ColumnReference)this.getNodeFactory().getNode(62, string, null, this.getContextManager());
            } else {
                this.generatedRef = (ColumnReference)this.getNodeFactory().getNode(62, this.generatedRC.getName(), null, this.getContextManager());
                this.generatedRef.setType(this.getTypeServices());
            }
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (n != -1) {
                this.generatedRef.setTableNumber(n);
            }
            resultColumnList.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceAggregate();
        } else {
            resultColumnList.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    AggregateDefinition getAggregateDefinition() {
        return this.uad;
    }

    public ResultColumn getGeneratedRC() {
        return this.generatedRC;
    }

    public ColumnReference getGeneratedRef() {
        return this.generatedRef;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        Object object;
        Object var5_4 = null;
        Object var6_5 = null;
        Object var7_6 = null;
        Object var8_7 = null;
        Object var9_8 = null;
        DataTypeDescriptor dataTypeDescriptor = null;
        TypeDescriptor typeDescriptor = null;
        ClassFactory classFactory = this.getClassFactory();
        this.classInspector = classFactory.getClassInspector();
        this.instantiateAggDef();
        vector.addElement(this);
        super.bindExpression(fromList, subqueryList, vector);
        if (this.operand != null) {
            object = new HasNodeVisitor(this.getClass(), class$Lorg$apache$derby$impl$sql$compile$ResultSetNode != null ? class$Lorg$apache$derby$impl$sql$compile$ResultSetNode : (class$Lorg$apache$derby$impl$sql$compile$ResultSetNode = AggregateNode.class$("org.apache.derby.impl.sql.compile.ResultSetNode")));
            this.operand.accept((Visitor)object);
            if (((HasNodeVisitor)object).hasNode()) {
                throw StandardException.newException("42Y33", this.aggregateName);
            }
            dataTypeDescriptor = this.operand.getTypeServices();
            if (this.uad instanceof CountAggregateDefinition && !dataTypeDescriptor.isNullable()) {
                this.setOperator(this.aggregateName);
                this.setMethodName(this.aggregateName);
            }
            if (this.distinct && !this.operand.getTypeId().orderable(classFactory)) {
                throw StandardException.newException("X0X67.S", dataTypeDescriptor.getTypeId().getSQLTypeName());
            }
            if (this.operand instanceof UntypedNullConstantNode) {
                throw StandardException.newException("42Y83", this.aggregateName);
            }
        }
        try {
            this.aggregatorClassName = new StringBuffer();
            typeDescriptor = this.uad.getAggregator(dataTypeDescriptor, this.aggregatorClassName);
        }
        catch (Exception exception) {
            throw StandardException.unexpectedUserException(exception);
        }
        if (typeDescriptor == null) {
            throw StandardException.newException("42Y22", this.aggregateName, (Object)this.operand.getTypeId().getSQLTypeName());
        }
        this.checkAggregatorClassName(this.aggregatorClassName.toString());
        object = TypeId.getBuiltInTypeId(typeDescriptor.getTypeName());
        if (object == null) {
            object = TypeId.getSQLTypeForJavaType(typeDescriptor.getTypeName());
        }
        this.setType(new DataTypeDescriptor((TypeId)object, typeDescriptor.getPrecision(), typeDescriptor.getScale(), typeDescriptor.isNullable(), typeDescriptor.getMaximumWidth()));
        return this;
    }

    private void checkAggregatorClassName(String string) throws StandardException {
        if (!this.classInspector.assignableTo(string = this.verifyClassExist(string, false), "org.apache.derby.iapi.sql.execute.ExecAggregator")) {
            throw StandardException.newException("42Y32", string, (Object)this.aggregateName, (Object)this.operand.getTypeId().getSQLTypeName());
        }
    }

    private void instantiateAggDef() throws StandardException {
        AggregateDefinition aggregateDefinition;
        String string;
        Class clazz = this.aggregateDefinitionClass;
        if (clazz == null) {
            string = this.aggregateDefinitionClassName;
            string = this.verifyClassExist(string, false);
            try {
                clazz = this.classInspector.getClass(string);
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        string = null;
        try {
            string = clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        if (!(string instanceof AggregateDefinition)) {
            throw StandardException.newException("42Y00", this.aggregateDefinitionClassName);
        }
        if (string instanceof MaxMinAggregateDefinition) {
            aggregateDefinition = (MaxMinAggregateDefinition)((Object)string);
            if (this.aggregateName.equals("MAX")) {
                ((MaxMinAggregateDefinition)aggregateDefinition).setMaxOrMin(true);
            } else {
                ((MaxMinAggregateDefinition)aggregateDefinition).setMaxOrMin(false);
            }
        }
        if (string instanceof SumAvgAggregateDefinition) {
            aggregateDefinition = (SumAvgAggregateDefinition)((Object)string);
            if (this.aggregateName.equals("SUM")) {
                ((SumAvgAggregateDefinition)aggregateDefinition).setSumOrAvg(true);
            } else {
                ((SumAvgAggregateDefinition)aggregateDefinition).setSumOrAvg(false);
            }
        }
        this.uad = (AggregateDefinition)((Object)string);
        this.setOperator(this.aggregateName);
        this.setMethodName(this.aggregateDefinitionClassName);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getAggregatorClassName() {
        return this.aggregatorClassName.toString();
    }

    public String getAggregateName() {
        return this.aggregateName;
    }

    public ResultColumn getNewAggregatorResultColumn(DataDictionary dataDictionary) throws StandardException {
        String string = this.aggregatorClassName.toString();
        TypeId typeId = TypeId.getSQLTypeForJavaType(string);
        ConstantNode constantNode = this.getNullNode(typeId, this.getContextManager());
        constantNode.bindExpression(null, null, null);
        return (ResultColumn)this.getNodeFactory().getNode(80, this.aggregateName, constantNode, this.getContextManager());
    }

    public ResultColumn getNewExpressionResultColumn(DataDictionary dataDictionary) throws StandardException {
        ValueNode valueNode = this.operand == null ? this.getNewNullResultExpression() : this.operand;
        return (ResultColumn)this.getNodeFactory().getNode(80, "##aggregate expression", valueNode, this.getContextManager());
    }

    public ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeId(), this.getContextManager());
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    public String toString() {
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

