/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DropStatementNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public class DropSPSNode
extends DropStatementNode {
    public String statementToString() {
        return "DROP STATEMENT";
    }

    public QueryTreeNode bind() throws StandardException {
        super.bind();
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        SPSDescriptor sPSDescriptor = null;
        if (schemaDescriptor.getUUID() != null) {
            sPSDescriptor = dataDictionary.getSPSDescriptor(this.getRelativeName(), schemaDescriptor);
        }
        if (sPSDescriptor == null) {
            throw StandardException.newException("42Y55", "DROP STATEMENT", (Object)this.getFullName());
        }
        if (sPSDescriptor.getType() == SPSDescriptor.SPS_TYPE_TRIGGER) {
            throw StandardException.newException("42Y82", this.getFullName());
        }
        return this;
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropSPSConstantAction(this.getSchemaDescriptor(), this.getRelativeName());
    }
}

